<?php
/**
 * Plugin Name: Erado Addons
 * Plugin URI:  http://joommasters.com
 * Description: Currently supports the following theme functionality: shortcodes, CPT.
 * Version:     1.0
 * Author:      Joommasters
 * Author URI: http://joommasters.com
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: erado-addons
 */

define( 'ERADO_ADDONS_URL', plugin_dir_url( __FILE__ ) );
define( 'ERADO_ADDONS_PATH', plugin_dir_path( __FILE__ ) );

if( ! function_exists('is_plugin_active') ){
    include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
}

/*
 * Load plugin textdomain
 */
function erado_toolkit_load_textdomain() {
    load_plugin_textdomain( 'erado-addons', false, ERADO_ADDONS_PATH . '/languages' );
}

function erado_admin_styles() {
    wp_enqueue_style('toolkit-css', ERADO_ADDONS_URL . 'assets/css/toolkit.css');
}
add_action('admin_print_styles', 'erado_admin_styles');

// Require JMS Addons
if ( is_plugin_active( 'kingcomposer/kingcomposer.php' ) ) {
    require_once ERADO_ADDONS_PATH . '/shortcodes/kc_functions.php';
}

// Require ReduxFramework
if ( !class_exists ( 'ReduxFramework' ) && file_exists ( ERADO_ADDONS_PATH . 'inc/ReduxCore/framework.php' ) ) {
    require_once ( ERADO_ADDONS_PATH .'inc/ReduxCore/framework.php' );

    function erado_custom_css_redux() {
        wp_register_style(
            'redux-custom-css',
            ERADO_ADDONS_URL . 'assets/css/redux-framework.css',
            array( 'redux-admin-css' ),
            time(),
            'all'
        );
        wp_enqueue_style('redux-custom-css');
    }
    add_action( 'redux/page/erado_option/enqueue', 'erado_custom_css_redux' );
}

require_once ( ERADO_ADDONS_PATH .'inc/testimonial/init.php' );
require_once ( ERADO_ADDONS_PATH .'inc/portfolio/init.php' );
require_once ( ERADO_ADDONS_PATH .'inc/aq_resize.php' );
/*
* [ Widget] - - - - - - - - - - - - - - - - - - - -
*/
require_once ( ERADO_ADDONS_PATH .'inc/widgets/widget-instagram.php' );
require_once ( ERADO_ADDONS_PATH .'inc/widgets/widget-social.php' );
require_once ( ERADO_ADDONS_PATH .'inc/widgets/widget-post.php' );

/*
* [ Mega Menu. ] - - - - - - - - - - - - - - - - - - - -
*/
require_once ERADO_ADDONS_PATH . '/inc/megamenu/megamenu.php';

//add more thumb-category

add_action( 'product_cat_add_form_fields', 'add_category_fields',100 );
add_action( 'product_cat_edit_form_fields','edit_category_fields',100 );
add_action( 'created_term', 'save_category_fields',10,3);
add_action( 'edit_term', 'save_category_fields',10,3);

function add_category_fields() { 
?>
    <div class="form-field product_cat_thumbnail1">
        <label><?php _e( 'Thumbnail 1', 'woocommerce' ); ?></label>
        <div class="product_image_src" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( wc_placeholder_img_src() ); ?>" width="60px" height="60px" /></div>
        <div style="line-height: 60px;">
            <input type="hidden" class="product_image_value" name="product_cat_thumbnail_id1" />
            <button type="button" class="upload_image_button1 button"><?php _e( 'Upload/Add image', 'woocommerce' ); ?></button>
            <button type="button" class="remove_image_button1 button"><?php _e( 'Remove image', 'woocommerce' ); ?></button>
        </div>
        <div class="clear"></div>
    </div>         
    <script type="text/javascript">
        upload_image(jQuery('.product_cat_thumbnail1'));
        function upload_image($element){
            // Only show the "remove image" button when needed
            if ( ! jQuery( '.product_image_value',$element ).val() ) {
                jQuery( '.remove_image_button1',$element ).hide();
            }

            // Uploading files
            var file_frame1;

            jQuery( '.upload_image_button1',$element ).on( 'click', function( event ) {

                event.preventDefault();

                // If the media frame already exists, reopen it.
                if ( file_frame1 ) {
                    file_frame1.open();
                    return;
                }

                // Create the media frame.
                file_frame1 = wp.media.frames.downloadable_file = wp.media({
                    title: '<?php _e( "Choose an image", "woocommerce" ); ?>',
                    button: {
                        text: '<?php _e( "Use image", "woocommerce" ); ?>'
                    },
                    multiple: false
                });

                // When an image is selected, run a callback.
                file_frame1.on( 'select', function() {
                    var attachment = file_frame1.state().get( 'selection' ).first().toJSON();
                    
                    jQuery( '.product_image_value',$element ).val( attachment.id );
                    jQuery( '.product_image_src > img',$element ).attr( 'src', attachment.sizes.thumbnail.url );
                    jQuery( '.remove_image_button1',$element ).show();
                });

                // Finally, open the modal.
                file_frame1.open();
            });

            jQuery( '.remove_image_button1',$element ).on( 'click', function() {
                jQuery( '.product_image_src img',$element ).attr( 'src', '<?php echo esc_js( wc_placeholder_img_src() ); ?>' );
                jQuery( '.product_image_value',$element ).val( '' );
                jQuery( '.remove_image_button1',$element ).hide();
                return false;
            });             
        }

    </script>       
    <?php
}
    
function edit_category_fields( $term ) {

    $thumbnail_id = absint( get_woocommerce_term_meta( $term->term_id, 'thumbnail_id1', true ) );

    if ( $thumbnail_id ) {
        $image = wp_get_attachment_thumb_url( $thumbnail_id );
    } else {
        $image = wc_placeholder_img_src();
    }
          
    ?>
    <tr class="form-field product_cat_thumbnail1">
        <th scope="row" valign="top"><label><?php _e( 'Thumbnail 1', 'woocommerce' ); ?></label></th>
        <td>
            <div class="product_image_src" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( $image ); ?>" width="60px" height="60px" /></div>
            <div style="line-height: 60px;">
                <input type="hidden" class="product_image_value" name="product_cat_thumbnail_id1" value="<?php echo $thumbnail_id; ?>" />
                <button type="button" class="upload_image_button1 button"><?php _e( 'Upload/Add image', 'woocommerce' ); ?></button>
                <button type="button" class="remove_image_button1 button"><?php _e( 'Remove image', 'woocommerce' ); ?></button>
            </div>
            <div class="clear"></div>
        </td>
    </tr>                
    <script type="text/javascript">
        upload_image(jQuery('.product_cat_thumbnail1'));
        function upload_image($element){
            // Only show the "remove image" button when needed
            if ( ! jQuery( '.product_image_value',$element ).val() ) {
                jQuery( '.remove_image_button1',$element ).hide();
            }

            // Uploading files
            var file_frame1;

            jQuery( '.upload_image_button1',$element ).on( 'click', function( event ) {

                event.preventDefault();

                // If the media frame already exists, reopen it.
                if ( file_frame1 ) {
                    file_frame1.open();
                    return;
                }

                // Create the media frame.
                file_frame1 = wp.media.frames.downloadable_file = wp.media({
                    title: '<?php _e( "Choose an image", "woocommerce" ); ?>',
                    button: {
                        text: '<?php _e( "Use image", "woocommerce" ); ?>'
                    },
                    multiple: false
                });

                // When an image is selected, run a callback.
                file_frame1.on( 'select', function() {
                    var attachment = file_frame1.state().get( 'selection' ).first().toJSON();
                    
                    jQuery( '.product_image_value',$element ).val( attachment.id );
                    jQuery( '.product_image_src > img',$element ).attr( 'src', attachment.sizes.thumbnail.url );
                    jQuery( '.remove_image_button1',$element ).show();
                });

                // Finally, open the modal.
                file_frame1.open();
            });

            jQuery( '.remove_image_button1',$element ).on( 'click', function() {
                jQuery( '.product_image_src img',$element ).attr( 'src', '<?php echo esc_js( wc_placeholder_img_src() ); ?>' );
                jQuery( '.product_image_value',$element ).val( '' );
                jQuery( '.remove_image_button1',$element ).hide();
                return false;
            });             
        }

    </script>       
    <?php
}
    
function save_category_fields( $term_id, $tt_id = '', $taxonomy = '' ) {
    if ( isset( $_POST['product_cat_thumbnail_id1'] ) && 'product_cat' === $taxonomy ) {
        update_woocommerce_term_meta( $term_id, 'thumbnail_id1', absint( $_POST['product_cat_thumbnail_id1'] ) );
    }      
}