<?php
$portfolio_container_class = $cat = '';
$portfolio_fullwidth       = erado_get_option( 'portfolio-fullwidth', 0 );
$pagination_type           = erado_get_option( 'portfolio-pagination-type', 'number-pagination' );

if ( $portfolio_fullwidth == 0 ) {
	$portfolio_container_class = 'container';
} else {
	$portfolio_container_class = 'portfolio-fullwidth pl_60 pr_60';
}

get_header(); ?>
<div class="fl-page-content">
	<?php get_template_part( 'views/page-heading/style', 1 ); ?>
	<div class="<?php echo $portfolio_container_class; ?>">
		<div class="row">

			<div id="main-content" class="col-md-12 col-sm-12 col-xs-12 mt_100 mb_70">
				<?php
					if ( erado_get_option( 'portfolio-number-per-page' ) ) {
						$limit = erado_get_option( 'portfolio-number-per-page' );
					} else {
						$limit = -1;
					}

					$columns = erado_get_option( 'portfolio-column' );

					$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

					// Filter portfolio post type
					$args = array(
						'post_type'      => 'portfolio',
						'post_status'    => 'publish',
						'posts_per_page' => $limit,
						'paged'          => $paged
					);

					if ( is_tax( 'portfolio_cat' ) ) {
						$cat = get_queried_object()->term_id;
					}

					if ( ! empty( $cat ) ) {
						$args['tax_query'] = array(
							'relation' => 'AND',
							array(
								'taxonomy' => 'portfolio_cat',
								'field'    => 'id',
								'terms'    => explode( ',', $cat )
							),
						);
					}
					$query = new WP_Query( $args );

					$i = 0;

					// Retrieve all the categories
					$filters = get_terms( 'portfolio_cat', array( 'include' => $cat ) );
				?>

				<?php if ( ! is_tax( 'portfolio_cat' ) ) { ?>
					<div class="portfolio-filter jms-filter mb_25">
						<a data-filter="*" class="selected dib" href="javascript:void(0);"><?php _e( 'All', 'erado-addons' ); ?></a>
						<?php foreach ( $filters as $cat ) : ?>
							<a data-filter=".<?php esc_attr_e( $cat->slug ); ?>" class="dib" href="javascript:void(0);"><?php esc_html_e( $cat->name ); ?></a>
						<?php endforeach; ?>
					</div>
				<?php } ?>

				<div class="portfolio-row row portfolio-layout erado-masonry portfolios" data-masonry='{"selector":".item","layoutMode":"masonry"}'>
					<?php while ( $query->have_posts() ) : $query->the_post(); ?>
						<?php
							// Get portfolio category
							$categories = wp_get_post_terms( get_the_ID(), 'portfolio_cat' );

							if ( $columns == 2 ) {
								$classes = array( 'col-md-6 item pr mb_30' );
							} elseif( $columns == 3 ) {
								$classes = array( 'col-md-4 item pr mb_30' );
							} elseif( $columns == 4 ) {
								$classes = array( 'col-md-3 item pr mb_30' );
							}

							if ( $categories ) {
								foreach ( $categories as $category ) {
									$classes[] = "{$category->slug}";
								}
							}
						?>
						<div id="portfolio-<?php the_ID(); ?>" class="col-sm-6 col-xs-12 <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
							<div class="item-animation">
								<div class="portfolio-item-inner pr<?php if ( !has_post_thumbnail() ) echo ' no-thumb'; ?>">
									<?php if ( has_post_thumbnail() ) : ?>
										<div class="portfolio-thumbnail oh">
											<?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) ); ?>
										</div>
									<?php endif; ?>
									<div class="portfolio-content tc pa">
										<div class="portfolio-text-wrapper">
											<div class="portfolio-text-inner">
												<a class="link dib" href="<?php the_permalink(); ?>"><i class="pe-7s-link"></i></a>
												<?php the_title('<h4 class="entry-title">', '</h4>'); ?>
												<?php if ( $categories ) {
													echo '<div class="portfolio-category">' . get_the_term_list( get_the_ID(), 'portfolio_cat', '', ', ' ) . '</div>';
												} ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<?php $i++; ?>
					<?php endwhile; ?>
				</div>
				<div class="clearfix"></div>
				<?php if ( 'load-more' == $pagination_type || 'infinite-scroll' == $pagination_type ) : ?>
					<div class="fl-ajax-load-more tc" data-load-more='{"page":"<?php echo esc_attr( $wp_query->max_num_pages ); ?>","container":"portfolio-layout","layout":"<?php echo $pagination_type; ?>"}'>
						<?php echo next_posts_link( esc_html__( 'Load More', 'erado' ) ); ?>
					</div>
				<?php else : ?>
					<?php erado_post_pagination(); ?>
				<?php endif; ?>


			</div>
			<!-- end content -->

		</div>
	</div>
</div>
<!-- fl-page-content -->

<?php get_footer(); ?>
