<?php
$rd_number = rand();
$el_class = apply_filters( 'kc-el-class', $atts );

extract($atts);

if ( !empty( $extra_class ) ) {
    $el_class[] = $extra_class;
}

if ( isset($template) && $template == '1' ) {
    $el_class[] = 'template-1';
} else {
    $el_class[] = 'template-2';
}
if ( isset($style_navigation) && $style_navigation == '2' ) {
    $el_class[] = 'big-arrow';
}
$item_class = array();
$item_class[] = 'effect-'.$hover_image;

$sticky = get_option( 'sticky_posts' );

$args = array(
	'posts_per_page' => ( !empty($total_items) && intval($total_items) ) ? $total_items : 3,
	'orderby'        => $orderby,
	'order'          => $order,
    'post__not_in'   => $sticky,
    'ignore_sticky_posts' => 1,
	'post_type'      => 'post',
	'post_status'    => 'publish',
);

$posts = new WP_Query( $args );

?>
<div id="jmsblog-box" class="<?php echo implode(' ', $el_class) ?>">
    <?php if( isset( $title ) && ! empty( $title ) ) : ?>
        <div class="addon-title mb_40">
            <h3><?php echo esc_attr($title); ?></h3>
            <?php if( isset( $description_addon ) && ! empty( $description_addon ) ) : ?>
                <p class="description"><?php echo esc_attr($description_addon); ?></p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
	<div class="blog-carousel-<?php echo intval($rd_number); ?> owl-carousel owl-theme">
		<?php
		if ( $posts->have_posts() ) {
			while ( $posts->have_posts() ) : $posts->the_post();
				?>
				<div class="item">

                    <?php if ( isset($template) && $template == '1' ) : ?>
                        <div class="blog-box">
                            <div class="post-thumbnail pr oh <?php echo implode(' ', $item_class); ?>">
                                <a href="<?php the_permalink(); ?>">
                                    <?php
                                    if ( has_post_thumbnail() ) {
                                        $img = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

                                        if ( $img[1] >= 550 && $img[2] >= 315 ) {
                                            if ( class_exists('Aq_Resize') ) {
                                                $image = aq_resize( $img[0], 550, 315, true );
                                            } else {
                                                $image = $img[0];
                                            }
                                            echo '<img src="' . esc_url( $image ) . '" width="550" height="315" alt="' . get_the_title() . '" />';
                                        } else {
                                            echo '<div class="placeholder pr">';
                                                echo '<img src="' . get_template_directory_uri() . '/assets/images/placeholder/blog-template-01.jpg" width="550" height="315" alt="' . get_the_title() . '" />';
                                                echo '<div>' . esc_html__( 'The photos should be at least 550 x 315px', 'erado-addons' ) . '</div>';
                                            echo '</div>';
                                        }

                                    } else {
                                        echo '<img src="' . get_template_directory_uri() . '/assets/images/placeholder/blog-template-01.jpg" width="550" height="315" alt="' . get_the_title() . '" />';
                                    }
                                    ?>
                                </a>

                                <div class="post-info">
        							<h2 class="post-title">
        								<a href="<?php the_permalink(); ?>" rel="bookmark">
        									<?php if( is_sticky() ) { echo '<span class="lnr lnr-pushpin"></span>'; } ?>
        									<?php the_title(); ?>
        								</a>
        							</h2>
        							<?php if( isset($show_excerpt) && $show_excerpt == 'yes' ) : ?>
        								<div class="post-excerpt">
        									<p><?php the_excerpt();//jms_4life_post_excerpt( intval($excerpt) ); ?></p>
        								</div>
        							<?php endif; ?>
        							<?php if( isset($show_author) || isset($show_category) || isset($show_date) || isset($show_comment) ) : ?>
        								<ul class="post-meta">
        									<?php if( isset($show_author) && $show_author == 'yes' ) : ?>
        										<li>
        											<i class="fa fa-user"></i>
        											<a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID'))); ?>"><?php echo esc_html( get_the_author() ); ?></a>
        										</li>
        									<?php endif; ?>
        									<?php if( isset($show_category) && $show_category == 'yes' ) : ?>
        										<li><i class="fa fa-folder-o"></i><?php echo the_category( ', ', 'single' ); ?></li>
        									<?php endif; ?>
        									<?php if( isset($show_date) && $show_date == 'yes' ) : ?>
        										<li><i class="blog-calendar"></i><?php echo '<span>' . get_the_time("M d, Y") . '</span>'; ?></li>
        									<?php endif; ?>
        									<?php if( isset($show_comment) && $show_comment == 'yes' ) : ?>
        										<li>
        											<i class="blog-eye"></i>
        											<a href="<?php echo get_comments_link(); ?>">
        												<?php echo get_comments_number(get_the_ID()) . ' ' . esc_html__( 'comments', 'erado-addons' ); ?>
        											</a>
        										</li>
        									<?php endif; ?>
        								</ul>
        							<?php endif; ?>
        						</div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if ( isset($template) && $template == '2' ) : ?>
                        <div class="blog-box flex">
                            <div class="post-thumbnail pr oh">
                                <a href="<?php the_permalink(); ?>">
                                    <?php
                                    if ( has_post_thumbnail() ) {
                                        $img = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

                                        if ( $img[1] >= 550 && $img[2] >= 315 ) {
                                            if ( class_exists('Aq_Resize') ) {
                                                $image = aq_resize( $img[0], 550, 315, true );
                                            } else {
                                                $image = $img[0];
                                            }
                                            echo '<img src="' . esc_url( $image ) . '" width="550" height="315" alt="' . get_the_title() . '" />';
                                        } else {
                                            echo '<div class="placeholder pr">';
                                                echo '<img src="' . get_template_directory_uri() . '/assets/images/placeholder/blog-template-01.jpg" width="550" height="315" alt="' . get_the_title() . '" />';
                                                echo '<div>' . esc_html__( 'The photos should be at least 432 x 315px', 'erado-addons' ) . '</div>';
                                            echo '</div>';
                                        }

                                    } else {
                                        echo '<img src="' . get_template_directory_uri() . '/assets/images/placeholder/blog-template-01.jpg" width="550" height="315" alt="' . get_the_title() . '" />';
                                    }
                                    ?>
                                </a>
                            </div>
                            <div class="post-info">
                                <h2 class="post-title">
                                    <a href="<?php the_permalink(); ?>" rel="bookmark">
                                        <?php if( is_sticky() ) { echo '<span class="lnr lnr-pushpin"></span>'; } ?>
                                        <?php the_title(); ?>
                                    </a>
                                </h2>
                                <?php if( isset($show_author) || isset($show_category) || isset($show_date) || isset($show_comment) ) : ?>
                                    <ul class="post-meta pr">
                                        <?php if( isset($show_author) && $show_author == 'yes' ) : ?>
                                            <li>
                                                <i class="fa fa-user"></i>
                                                <a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta('ID'))); ?>"><?php echo esc_html( get_the_author() ); ?></a>
                                            </li>
                                        <?php endif; ?>
                                        <?php if( isset($show_category) && $show_category == 'yes' ) : ?>
                                            <li><i class="fa fa-folder-o"></i><?php echo the_category( ', ', 'single' ); ?></li>
                                        <?php endif; ?>
                                        <?php if( isset($show_date) && $show_date == 'yes' ) : ?>
                                            <li><i class="blog-calendar"></i><?php echo '<span>' . get_the_time("M d, Y") . '</span>'; ?></li>
                                        <?php endif; ?>
                                        <?php if( isset($show_comment) && $show_comment == 'yes' ) : ?>
                                            <li>
                                                <i class="blog-eye"></i>
                                                <a href="<?php echo get_comments_link(); ?>">
                                                    <?php echo get_comments_number(get_the_ID()) . ' ' . esc_html__( 'comments', 'erado-addons' ); ?>
                                                </a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                <?php endif; ?>
                                <?php if( isset($show_excerpt) && $show_excerpt == 'yes' ) : ?>
                                    <div class="post-excerpt">
                                        <p><?php erado_post_excerpt( intval($excerpt) ); ?></p>
                                    </div>
                                <?php endif; ?>
                                <div class="read-more">
                                    <a href="<?php the_permalink(); ?>"><?php echo esc_html__('Read More', 'erado'); ?></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
				</div>
				<?php
			endwhile; wp_reset_postdata();
		}
		?>
	</div>

</div>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		var rtl = false;
    	if ($('body').hasClass('rtl')) rtl = true;

	    $('.blog-carousel-<?php echo intval($rd_number); ?>').owlCarousel({
            responsive : {
                320 : {
	        		items: 1,
                    margin: 30
	        	},
				480 : {
	        		items: <?php if( (int) $items_mobile > 0) { echo esc_js($items_mobile); } else { echo '1'; } ?>,
                    margin: 30
	        	},
			    768 : {
			        items: <?php if( (int) $items_tablet > 0) { echo esc_js($items_tablet); } else { echo '2'; } ?>,
                    margin: 30
			    },
			    991 : {
			        items: <?php if( (int) $items_medium > 0) { echo esc_js($items_medium); } else { echo '3'; } ?>,
                    margin: 30
			    },
			    1199 : {
			        items: <?php if( (int) $items_show > 0) { echo esc_js($items_show); } else { echo '3'; } ?>,
			    }
			},
			rtl: rtl,
	        margin: <?php if( (int) $items_space > 0) { echo esc_js($items_space); } else { echo '30'; } ?>,
	        dots: <?php if( $show_pagination == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
	        nav: <?php if( $show_navigation == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
	        autoplay: <?php if( $autoplay == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
	        loop: <?php if( $loop == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
	        autoplayTimeout: <?php if( (int) $autoplaytimeout > 0 ) { echo esc_js($autoplaytimeout); } else { echo '5000'; } ?>,
	        smartSpeed: 1000,
			navText: ['<i class="icon-arrow prev"></i>','<i class="icon-arrow next"></i>']
	    });
	});
</script>
