<?php
/**
 * Portfolio custom post type.
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

class Erado_Addons_Testimonial {
	/**
	 * Construct function.
	 *
	 * @return  void
	 */
	function __construct() {
		add_action( 'init', array( __CLASS__, 'testimonial_init' ) );
	}

	/**
	 * Register a testimonial post type.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/register_post_type
	 */
	public static function testimonial_init() {
		register_post_type( 'testimonial',
			array(
				'public'             => true,
				'publicly_queryable' => true,
				'show_ui'            => true,
				'show_in_menu'       => true,
				'query_var'          => true,
				'rewrite'            => array( 'slug' => 'testimonial' ),
				'capability_type'    => 'post',
				'has_archive'        => true,
				'hierarchical'       => false,
				'menu_position'      => 99,
				'menu_icon'          => 'dashicons-welcome-widgets-menus',
				'supports'           => array( 'title', 'editor', 'thumbnail' ),
				'labels'             => array(
					'name'               => _x( 'Testimonial', 'erado-addons' ),
					'singular_name'      => _x( 'Testimonial', 'erado-addons' ),
					'menu_name'          => _x( 'Testimonial', 'erado-addons' ),
					'name_admin_bar'     => _x( 'Testimonial', 'erado-addons' ),
					'add_new'            => _x( 'Add New', 'erado-addons' ),
					'add_new_item'       => __( 'Add New Testimonial', 'erado-addons' ),
					'new_item'           => __( 'New Testimonial', 'erado-addons' ),
					'edit_item'          => __( 'Edit Testimonial', 'erado-addons' ),
					'view_item'          => __( 'View Testimonial', 'erado-addons' ),
					'all_items'          => __( 'All Testimonial', 'erado-addons' ),
					'search_items'       => __( 'Search Testimonial', 'erado-addons' ),
					'parent_item_colon'  => __( 'Parent Testimonial:', 'erado-addons' ),
					'not_found'          => __( 'No testimonials found.', 'erado-addons' ),
					'not_found_in_trash' => __( 'No testimonials found in Trash.', 'erado-addons' )
				),
			)
		);

	}
}
$testimonial = new Erado_Addons_Testimonial;
