<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



function kc_addons_init() {
 	global $kc;
    $kc->set_template_path( ERADO_ADDONS_PATH . 'templates/' );
	$kc->set_template_path( get_template_directory() . '/kc-templates/' );

    $product_type = array(
		'recent-product'      => __('Recent Products', 'erado-addons'),
		'featured-product'    => __('Featured Products', 'erado-addons'),
		'best-seller-product' => __('Best Seller Products', 'erado-addons'),
		'sale-product'        => __('Sales Products', 'erado-addons'),
	);
    $order_by_values = array(
		'date'          => __( 'Date', 'erado-addons' ),
		'ID'            => __( 'ID', 'erado-addons' ),
		'author'        => __( 'Author', 'erado-addons' ),
		'title'         => __( 'Title', 'erado-addons' ),
		'rand'          => __( 'Random', 'erado-addons' ),
	);

	$order_way_values = array(
		'DESC' => __( 'Descending', 'erado-addons' ),
		'ASC' => __( 'Ascending', 'erado-addons' )
	);

	$terms = get_terms( 'product_cat');
	$term = array();
	foreach( $terms as $cat ){
		$term[$cat->term_id] = $cat->slug;
	}

	$kc->add_map(
        array(
            'kc_banner' => array(
				'name'        => 'Banner',
				'description' => __('Display Banner', 'erado-addons'),
				'icon'        => 'jms-icon',
				'category'    => 'JMS Addons',
				'css_box'     => true,
				'is_container' => true,
				'params'      => array(
					'general' => array(
						array(
							'name'        => 'banner_image',
							'label'       => __( 'Images', 'erado-addons' ),
							'description' => __( 'Upload image', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'attach_image',
						),
						array(
							'name'        => 'hover_image',
							'label'       => __( 'Image Effect', 'erado-addons' ),
							'description' => __( 'View demo this <a href="http://localhost/wp/jms_erado/effect-demo/"  target="_blank"> link </a>', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	 	  => 'Effect 1',
								'2'	 	  => 'Effect 2',
								'3'	  	  => 'Effect 3',
								'4'	  	  => 'Effect 4',
								'5'	  	  => 'Effect 5',
								'6'	  	  => 'Effect 6',
								'7'	  	  => 'Effect 7',
								'8'	  	  => 'Effect 8',
								'9'	  	  => 'Effect 9',
								'10'	  => 'Effect 10',
								'11'	  => 'Effect 11',
								'12'	  => 'Effect 12',
								'13'	  => 'Effect 13',
								'14'	  => 'Effect 14',
								'15'	  => 'Effect 15',
								'16'	  => 'Effect 16',
								'19'	  => 'No Effect',
							),
							'value'		  => '1',
						),
						array(
							'name'  => 'banner_link',
							'label' => 'Banner link',
							'type'  => 'text',
							'value' => '#'
						),
						array(
							'name'        => 'text_1',
							'label'       => __( 'Text 1', 'erado-addons' ),
							'type'        => 'text',
						),
						array(
							'name'        => 'text_2',
							'label'       => __( 'Text 2', 'erado-addons' ),
							'type'        => 'text',
						),
						array(
							'name'        => 'text_3',
							'label'       => __( 'Text 3', 'erado-addons' ),
							'type'        => 'text',
						),
						array(
							'name'        => 'other_form',
							'label'       => __( 'Special Form html', 'erado-addons' ),
							'description' => __( 'Text 1 and Text 2 will be replace by this content', 'erado-addons' ),
							'type'        => 'toggle',
						),
						array(
							'name'        => 'content',
							'label'       => __( 'Form html', 'erado-addons' ),
							'type'        => 'textarea_html',
							'relation' => array(
						        'parent'    => 'other_form',
						        'show_when' => 'yes'
						    )
						),
						array(
							'name'        => 'show_button',
							'label'       => __( 'Display Button', 'erado-addons' ),
							'type'        => 'toggle',
						),
						array(
							'name'        => 'button_text',
							'label'       => __( 'Text Button', 'erado-addons' ),
							'type'        => 'text',
							'value' 	  => 'Shop Now',
							'relation' => array(
						        'parent'    => 'show_button',
						        'show_when' => 'yes'
						    )
						),
						array(
							'name'        => 'button_link',
							'label'       => __( 'Link Button', 'erado-addons' ),
							'type'        => 'link',
							'relation' => array(
						        'parent'    => 'show_button',
						        'show_when' => 'yes'
						    )
						),
						array(
							'name'        => 'extra_class',
							'label'       => __( 'Extra Class', 'erado-addons' ),
							'type'        => 'text',
						),
                    ),
					'Styling' => array(
                    	//1st field
	                    array(
	                        'name' => 'my-css',
	                        'label' => 'Field Label',
	                        'type' => 'css',
	                        'options' => array(
	                        	array(
									'screens' => 'any,1024,999,767,479',
									'Typography' => array(
										array('property' => 'background', 'label' => 'Background', 'selector' => '.banner-text'),
										array('property' => 'color', 'label' => 'Color', 'selector' => '.banner-text'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.banner-text'),
										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.banner-text'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.banner-text'),
									),
									'Text 1' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.banner-text-1 p'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.banner-text-1 p'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.banner-text-1 p'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.banner-text-1 p'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.banner-text-1 p'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.banner-text-1 p'),
										array('property' => 'text-shadow', 'label' => 'Text Shadow', 'selector' => '.banner-text-1 p'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.banner-text-1 p'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.banner-text-1 p'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.banner-text-1 p'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.banner-text-1 p'),
										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.banner-text-1 p'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.banner-text-1 p'),
									),
									'Text 2' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.banner-text-2 p'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.banner-text-2 p'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.banner-text-2 p'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.banner-text-2 p'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.banner-text-2 p'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.banner-text-2 p'),
										array('property' => 'text-shadow', 'label' => 'Text Shadow', 'selector' => '.banner-text-2 p'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.banner-text-2 p'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.banner-text-2 p'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.banner-text-2 p'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.banner-text-2 p'),
										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.banner-text-2 p'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.banner-text-2 p'),
									),
									'Text 3' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.banner-text-3 p'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.banner-text-3 p'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.banner-text-3 p'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.banner-text-3 p'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.banner-text-3 p'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.banner-text-3 p'),
										array('property' => 'text-shadow', 'label' => 'Text Shadow', 'selector' => '.banner-text-3 p'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.banner-text-3 p'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.banner-text-3 p'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.banner-text-3 p'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.banner-text-3 p'),
										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.banner-text-3 p'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.banner-text-3 p'),
									),
									'Button' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.content-button a'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.content-button a'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.content-button a'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.content-button a'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.content-button a'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.content-button'),
										array('property' => 'border', 'label' => 'Border', 'selector' => '.content-button a'),
										array('property' => 'text-shadow', 'label' => 'Text Shadow', 'selector' => '.content-button a'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.content-button a'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.content-button a'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.content-button a'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.content-button a'),
										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.content-button'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.content-button a'),
									),
									'Button Hover' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.content-button a:hover'),
										array('property' => 'background-color', 'label' => 'Background', 'selector' => '.content-button a:hover'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.content-button a:hover'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.content-button a:hover'),
										array('property' => 'border', 'label' => 'Border', 'selector' => '.content-button a:hover'),
										array('property' => 'text-shadow', 'label' => 'Text Shadow', 'selector' => '.content-button a:hover'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.content-button a:hover'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.content-button a:hover'),
									),
									'Box' => array(
										array('property' => 'color', 'label' => 'Color'),
										array('property' => 'text-align', 'label' => 'Text Align'),
										array('property' => 'margin', 'label' => 'Margin'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.banner-text'),
									),
								),
	                        ),
	                    ),
                    )
				),
			), //end kc_banner
            'kc_blog' => array(
				'name'        => 'Blog Slider',
				'description' => __('Display Blog Slider', 'erado-addons'),
				'icon'        => 'jms-icon',
				'category'    => 'JMS Addons',
				'css_box'     => true,
				'is_container' => true,
				'params'      => array(
					'general' => array(
						array(
							'name'        => 'title',
							'label'       => __('Title', 'erado-addons'),
							'type'        => 'text',
							'value'       => '',
						),
						array(
							'name'        => 'description_addon',
							'label'       => 'Desciption BLog',
							'description' => __( 'Desciption Blog.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'textarea',
							'value'       => ''
	                    ),
						array(
							'name'        => 'template',
							'label'       => __('Select Template', 'erado-addons'),
							'type'        => 'radio_image',
							'options'     => array(
								'1' => ERADO_ADDONS_URL . 'assets/images/blog/blog-template-01.jpg',
								'2' => ERADO_ADDONS_URL . 'assets/images/blog/blog-template-02.jpg',
							),
							'value'       => '1',
						),
						array(
							'name'        => 'hover_image',
							'label'       => __( 'Image Effect', 'erado-addons' ),
							'description' => __( 'View demo this <a href="http://localhost/wp/jms_erado/effect-demo/"  target="_blank"> link </a>', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	 	  => 'Effect 1',
								'2'	 	  => 'Effect 2',
								'3'	  	  => 'Effect 3',
								'4'	  	  => 'Effect 4',
								'5'	  	  => 'Effect 5',
								'6'	  	  => 'Effect 6',
								'7'	  	  => 'Effect 7',
								'8'	  	  => 'Effect 8',
								'9'	  	  => 'Effect 9',
								'10'	  => 'No Effect',
							),
							'value'		  => '1',
						),
						array(
							'name'        => 'total_items',
							'label'       => 'Total Items',
							'description' => __( 'Total Items.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '6'
						),
						array(
							'name'         => 'orderby',
							'label'        => 'Order by',
							'desccription' => '',
							'type'         => 'select',
							'options'       => $order_by_values
						),
						array(
							'name'         => 'order',
							'label'        => 'Order by',
							'desccription' => sprintf( __( 'Designates the ascending or descending order. More at %s.', 'erado-addons' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
							'type'         => 'select',
							'options'       => $order_way_values
						),
						array(
							'name'        => 'show_excerpt',
							'label'       => 'Show Excerpt',
							'description' => __( 'Show/Hide excerpt', 'erado-addons' ),
							'type'        => 'toggle',
							'value'       => 'show',
							'relation'    => array(
								'parent'    => 'template',
								'show_when' => '2'
							)
						),
						array(
							'name'        => 'excerpt',
							'label'       => 'Excerpt',
							'description' => __( 'Number of word limit for introtext', 'erado-addons' ),
							'type'        => 'text',
							'value'       => '20',
							'relation'    => array(
								'parent'    => 'template',
								'show_when' => '2'
							)
						),
						array(
							'name'        => 'show_category',
							'label'       => 'Show Category',
							'description' => __( 'Show/Hide category', 'erado-addons' ),
							'type'        => 'toggle',
							'value'       => 'no'
						),
						array(
							'name'        => 'show_author',
							'label'       => 'Show Author',
							'description' => __( 'Show/Hide author', 'erado-addons' ),
							'type'        => 'toggle',
							'value'       => 'no'
						),
						array(
							'name'        => 'show_date',
							'label'       => 'Show Date',
							'description' => __( 'Show/Hide date', 'erado-addons' ),
							'type'        => 'toggle',
							'value'       => 'yes'
						),
						array(
							'name'        => 'show_comment',
							'label'       => 'Show Comment',
							'description' => __( 'Show/Hide comment', 'erado-addons' ),
							'type'        => 'toggle',
							'value'       => 'yes'
						),
                        array(
							'name'        => 'extra_class',
							'label'       => __( 'Extra Class', 'erado-addons' ),
							'type'        => 'text',
						),
					),
					'Slider Settings' => array(
						array(
							'name'        => 'items_show',
							'label'       => 'Items Show',
							'description' => __( 'Number of Items Show ( > 1199px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '3'
						),
						array(
							'name'        => 'items_medium',
							'label'       => 'Items Show On Medium Device.',
							'description' => __( 'Items Show On Medium Device.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '3'
						),
						array(
							'name'        => 'items_tablet',
							'label'       => 'Items Show On Tablet',
							'description' => __( 'Items Show On Tablet Device.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '2'
						),
						array(
							'name'        => 'items_mobile',
							'label'       => 'Items Show On Mobile',
							'description' => __( 'Number of Items Show On Mobile( >= 320px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1'
						),
						array(
							'name'        => 'items_space',
							'label'       => 'Margin-right(px) on item',
							'admin_label' => true,
							'type' => 'number_slider',  // USAGE RADIO TYPE
							'options' => array(    // REQUIRED
								'min' => 30,
								'max' => 60,
								'unit' => '',
								'show_input' => false
							),
							'value'       => '15'
	                    ),
						array(
							'name'        => 'show_navigation',
							'label'       => 'Show Navigation',
							'description' => __( 'Show/Hide navigation', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
								'show' => 'Show',
							),
							'value' => ''
						),
						array(
							'name'        => 'style_navigation',
							'label'       => __( 'Style navigation', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	  => 'Small icon',
								'2'	  => 'Big icon',
							),
							'value'		  => '2',
						),
						array(
							'name'        => 'show_pagination',
							'label'       => 'Show Pagination',
							'description' => __( 'Show/Hide pagination', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
								'show' => 'Show',
							),
							'value' => 'show'
						),
						array(
							'name'        => 'autoplay',
							'label'       => 'Auto Play',
							'description' => __( 'Enable/Disable Auto Play', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
								'yes' => 'Yes',
							),
							'value' => 'yes'
						),
						array(
							'name'        => 'autoplaytimeout',
							'label'       => 'Auto Play Timeout',
							'description' => __( 'Set Auto Play Timeout. Ex: 1000(ms) = 1s.', 'erado-addons' ),
							'type'        => 'text',
							'value' => '5000'
						),
						array(
							'name'        => 'loop',
							'label'       => 'Loop',
							'description' => __( 'Enable/Disable Loop', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
								'yes' => 'Yes',
							),
							'value' => ''
						),
					),
					'Styling' => array(
						//1st field
						array(
							'name' => 'my-css',
							'label' => 'Field Label',
							'type' => 'css',
							'options' => array(
								array(
									'screens' => 'any,1024,999,767,479',
									'Title' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title h3'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title h3'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title h3'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title h3'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title h3'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title h3'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title h3'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => 'addon-title h3'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title h3'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title h3'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title h3'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title h3'),
									),
									'Desciption' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title p'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title p'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title p'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title p'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title p'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title p'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title p'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.addon-title p'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title p'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title p'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title p'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title p'),
									),
									'Meta' => array(
										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.post-meta'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.post-meta'),
									),
									'Box' => array(
										array('property' => 'margin', 'label' => 'Margin'),
										array('property' => 'padding', 'label' => 'Padding'),
										array('property' => 'border', 'label' => 'Border'),
									),
								),
							),
						),
					)
				)
			),
			// End of elemnt kc_blog
			'kc_featured_category' => array(
				'name'        => 'Featured Category',
				'description' => __('Display Featured Category', 'erado-addons'),
				'icon'        => 'jms-icon',
				'category'    => 'JMS Addons',
				'css_box'     => true,
				'is_container' => true,
				'params'      => array(
					'general' => array(
						array(
							'name'        => 'title',
							'label'       => __('Featured Category', 'erado-addons'),
							'type'        => 'text',
							'value'       => '',
						),
						array(
							'name'        => 'description_addon',
							'label'       => 'Desciption',
							'description' => __( 'Desciption.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'textarea',
							'value'       => ''
	                    ),
						array(
							'name'        => 'product_style',
							'label'       => __('Select Template', 'erado-addons'),
							'type'        => 'dropdown',
							'options'     => array(
								'1' => 'Style 1',
								'2' => 'Style 2',
							),
							'value'       => '1',
						),
						array(
							'name'        => 'show_thumb',
							'label'       => __('Select Thumb Image', 'erado-addons'),
							'type'        => 'dropdown',
							'options'     => array(
								'1' => 'Thumb Image',
								'2' => 'Thumb1 Image',
							),
							'value'       => '1',
						),
						array(
							'name'        => 'total_items',
							'label'       => 'Total Items',
							'description' => __( 'Total Items.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '12'
						),
						array(
							'name'         => 'category',
							'label'        => 'Category',
							'desccription' => '',
							'type'         => 'checkbox',
							'options'       => $term,
						),
						array(
							'name'        => 'show_count',
							'label'       => 'Show Count Number',
							'description' => __( 'Show/Hide category', 'erado-addons' ),
							'type'        => 'toggle',
							'value'       => 'yes'
						),
                        array(
							'name'        => 'extra_class',
							'label'       => __( 'Extra Class', 'erado-addons' ),
							'type'        => 'text',
						),
					),
					'Slider Settings' => array(
						array(
							'name'        => 'show_hide_carousel',
							'label'       => __( 'Carousel Slider', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'yes'	  => 'Enable',
								'no'	  => 'Disable',
							),
							'value'		  => 'yes',
						),

						array(
							'name'        => 'number_of_rows',
							'label'       => 'Number of rows',
							'description' => __( 'Number of rows.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
                    	array(
							'name'        => 'items_show',
							'label'       => 'Items Show',
							'description' => __( 'Number of Items Show ( > 1199px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '4',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_medium',
							'label'       => 'Items Show On Medium Device.',
							'description' => __( 'Items Show On Medium Device (>= 991px)', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '3',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_tablet',
							'label'       => 'Items Show On Tablet',
							'description' => __( 'Items Show On Tablet Device (>= 768px)', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '2',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_mobile',
							'label'       => 'Items Show On Mobile',
							'description' => __( 'Number of Items Show On Mobile( >= 480px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '2',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
						array(
							'name'        => 'items_space',
							'label'       => 'Margin-right(px) on item',
							'admin_label' => true,
							'type' => 'number_slider',  // USAGE RADIO TYPE
							'options' => array(    // REQUIRED
								'min' => 30,
								'max' => 60,
								'unit' => '',
								'show_input' => false
							),
							'value'       => '30',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'show_navigation',
							'label'       => 'Show Navigation',
							'description' => __( 'Show/Hide navigation', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                        'value' => 'show',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'style_navigation',
							'label'       => __( 'Style navigation', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	  => 'Small icon',
								'2'	  => 'Big icon',
							),
							'value'		  => '2',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
						),
	                    array(
							'name'        => 'show_pagination',
							'label'       => 'Show Pagination',
							'description' => __( 'Show/Hide pagination', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'autoplay',
							'label'       => 'Auto Play',
							'description' => __( 'Enable/Disable Auto Play', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'Yes',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'autoplaytimeout',
							'label'       => 'Auto Play Timeout',
							'description' => __( 'Set Auto Play Timeout. Ex: 1000(ms) = 1s.', 'erado-addons' ),
							'type'        => 'text',
	                        'value' => '5000',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'loop',
							'label'       => 'Loop',
							'description' => __( 'Enable/Disable Loop', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'Yes',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'number_of_columns',
							'label'       => 'Number of columns',
							'description' => __( 'Number of cols', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'select',
							'options'      => array(
								'2' => __( '2 Columns', 'erado' ),
			                    '3' => __( '3 Columns', 'erado' ),
			                    '4' => __( '4 Columns', 'erado' ),
								'5' => __( '5 Columns', 'erado' ),
								'6' => __( '6 Columns', 'erado' )
							),
							'value'       => '4',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'no'
						    ),
	                    ),
						array(
							'name'        => 'columns_gap',
							'label'       => 'Columns Gap',
							'description' => __( 'The distance between the columns', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'number_slider',
							'options'     => array(
								'min' 		 => 30,
								'max'        => 60,
								'unit'       => '',
								'show_input' => false
							),
							'value'       => '30',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'no'
						    ),
	                    ),
                    ),
					'Styling' => array(
	                    array(
							'name'    => 'my-css',
							'label'   => 'Field Label',
							'type'    => 'css',
							'options' => array(
	                        	array(
									'screens' => 'any,1024,999,767,479',
									'Title' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title h3'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title h3'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title h3'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title h3'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title h3'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title h3'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title h3'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => 'addon-title h3'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title h3'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title h3'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title h3'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title h3'),
									),
									'Desciption' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title p'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title p'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title p'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title p'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title p'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title p'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title p'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.addon-title p'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title p'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title p'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title p'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title p'),
									),
									'Box' => array(
										array('property' => 'margin', 'label' => 'Margin'),
										array('property' => 'padding', 'label' => 'Padding'),
										array('property' => 'border', 'label' => 'Border'),
									),
								),
	                        ),
	                    ),
					)
				)
			),
			// End featured category
            'kc_brand' => array(
				'name'        => 'Brand Slider',
				'description' => __('Display Brand Slider', 'erado-addons'),
				'icon'        => 'jms-icon',
				'category'    => 'JMS Addons',
				'css_box'     => true,
				'is_container' => true,
				'params'      => array(
					'general' => array(
						array(
							'name'        => 'title',
							'label'       => __('Title', 'erado-addons'),
							'type'        => 'text',
							'value'       => '',
						),
						array(
							'name'        => 'description_addon',
							'label'       => 'Desciption',
							'description' => __( 'Desciption.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'textarea',
							'value'       => ''
	                    ),
						array(
							'name'        => 'brand_image',
							'label'       => __( 'Images', 'erado-addons' ),
							'description' => __( 'Upload multiple image for carousel', 'erado-addons' ),
							'type'        => 'attach_images',
						),
                        array(
							'name'        => 'extra_class',
							'label'       => __( 'Extra Class', 'erado-addons' ),
							'type'        => 'text',
						),
                    ),
					'Slider Settings' => array(
                    	array(
							'name'        => 'items_show',
							'label'       => 'Items Show',
							'description' => __( 'Number of Items Show ( > 1199px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '6'
	                    ),
	                    array(
							'name'        => 'items_medium',
							'label'       => 'Items Show On Medium Device.',
							'description' => __( 'Items Show On Medium Device.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '5'
	                    ),
	                    array(
							'name'        => 'items_tablet',
							'label'       => 'Items Show On Tablet',
							'description' => __( 'Items Show On Tablet Device.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '4'
	                    ),
	                    array(
							'name'        => 'items_mobile',
							'label'       => 'Items Show On Mobile',
							'description' => __( 'Number of Items Show On Mobile( >= 320px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '3'
	                    ),
	                    array(
							'name'        => 'show_navigation',
							'label'       => 'Show Navigation',
							'description' => __( 'Show/Hide navigation', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                        'value' => ''
	                    ),
	                    array(
							'name'        => 'style_navigation',
							'label'       => __( 'Style navigation', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	  => 'Small icon',
								'2'	  => 'Big icon',
							),
							'value'		  => '2',
						),
	                    array(
							'name'        => 'show_pagination',
							'label'       => 'Show Pagination',
							'description' => __( 'Show/Hide pagination', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                        'value' => 'show'
	                    ),
	                    array(
							'name'        => 'autoplay',
							'label'       => 'Auto Play',
							'description' => __( 'Enable/Disable Auto Play', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'Yes',
	                        ),
	                        'value' => 'yes'
	                    ),
	                    array(
							'name'        => 'autoplaytimeout',
							'label'       => 'Auto Play Timeout',
							'description' => __( 'Set Auto Play Timeout. Ex: 1000(ms) = 1s.', 'erado-addons' ),
							'type'        => 'text',
	                        'value' => '5000'
	                    ),
	                    array(
							'name'        => 'loop',
							'label'       => 'Loop',
							'description' => __( 'Enable/Disable Loop', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'Yes',
	                        ),
	                        'value' => ''
	                    ),
                    ),
					'Styling' => array(
						//1st field
						array(
							'name' => 'my-css',
							'label' => 'Field Label',
							'type' => 'css',
							'options' => array(
								array(
									'screens' => 'any,1024,999,767,479',
									'Title' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title h3'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title h3'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title h3'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title h3'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title h3'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title h3'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title h3'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => 'addon-title h3'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title h3'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title h3'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title h3'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title h3'),
									),
									'Desciption' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title p'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title p'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title p'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title p'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title p'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title p'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title p'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.addon-title p'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title p'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title p'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title p'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title p'),
									),
									'Box' => array(
										array('property' => 'margin', 'label' => 'Margin'),
										array('property' => 'padding', 'label' => 'Padding'),
										array('property' => 'border', 'label' => 'Border'),
									),
								),
							),
						),
					)
				)
			),
			// End of elemnt kc_brand
            'kc_product_tab' => array(
				'name' => 'Product Tab Slider',
				'description'  => __( 'Display product tab carousel slider', 'erado-addons' ),
				'icon'         => 'jms-icon',
				'category'     => 'JMS Addons',
				'css_box'      => true,
				'is_container' => true,
				'params'       => array(
					'general' => array(
						array(
							'name'        => 'title',
							'label'       => __('Title', 'erado-addons'),
							'type'        => 'text',
							'value'       => '',
						),
						array(
							'name'        => 'description_addon',
							'label'       => 'Desciption Product',
							'description' => __( 'Desciption Product.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'textarea',
							'value'       => ''
	                    ),
	                    array(
							'name'        => 'show_new',
							'type'        => 'checkbox',
							'label'       => __( 'New Product Tab', 'erado-addons' ),
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                    ),
	                    array(
							'name'        => 'title_new',
							'type'        => 'text',
							'description'       => __( 'Title new product tab', 'erado-addons' ),
							'value'		  => 'New Arrivals',
	                        'relation' => array(
						        'parent'    => 'show_new',
						        'show_when' => 'show'
						    ),
	                    ),
						array(
							'name'        => 'show_featured',
							'type'        => 'checkbox',
							'label'       => __( 'Featured Product Tab', 'erado-addons' ),
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                    ),
	                    array(
							'name'        => 'title_featured',
							'type'        => 'text',
							'description'       => __( 'Title featured product tab', 'erado-addons' ),
							'value'		  => 'Featured',
	                        'relation' => array(
						        'parent'    => 'show_featured',
						        'show_when' => 'show'
						    ),
	                    ),
	                    array(
							'name'        => 'show_bestseller',
							'type'        => 'checkbox',
							'label'       => __( 'Bestseller Product Tab', 'erado-addons' ),
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                    ),
	                    array(
							'name'        => 'title_bestseller',
							'type'        => 'text',
							'description'       => __( 'Title bestseller product tab', 'erado-addons' ),
							'value'		  => 'Bestseller',
	                        'relation' => array(
						        'parent'    => 'show_bestseller',
						        'show_when' => 'show'
						    ),
	                    ),
	                    array(
							'name'        => 'show_sale',
							'type'        => 'checkbox',
							'label'       => __( 'Sale Product Tab', 'erado-addons' ),
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                    ),
	                    array(
							'name'        => 'title_sale',
							'type'        => 'text',
							'description'       => __( 'Title sale product tab', 'erado-addons' ),
							'value'		  => 'New Arrivals',
	                        'relation' => array(
						        'parent'    => 'show_sale',
						        'show_when' => 'show'
						    ),
	                    ),
						array(
							'name'        => 'total_items',
							'label'       => __( 'Total items', 'erado-addons' ),
							'description' => __( 'Total items', 'erado-addons' ),
							'type'        => 'text',
							'value'       => '12'
						),
	                    array(
							'name'        => 'product_style',
							'label'       => __( 'Product Style', 'erado-addons' ),
							'type'        => 'radio_image',
							'options'     => array(
								'1' => ERADO_ADDONS_URL . 'assets/images/product/product-style-1.jpg',
								'2' => ERADO_ADDONS_URL . 'assets/images/product/product-style-2.jpg',
							),
							'value'       => '1',
						),
						array(
							'name'        => 'hover_image',
							'label'       => __( 'Image Product Effect', 'erado-addons' ),
							'description' => __( 'View demo this <a href="http://localhost/wp/jms_erado/effect-demo/"  target="_blank"> link </a>', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	 	  => 'Effect 1',
								'2'	 	  => 'Effect 2',
								'3'	  	  => 'Effect 3',
								'4'	  	  => 'Effect 4',
								'5'	  	  => 'Effect 5',
								'6'	   	  => 'Effect 6',
								'7'	 	  => 'Effect 7',
								'8'	  	  => 'Effect 8',
								'9'	  	  => 'Effect 9',
								'10'	  => 'Effect 10',
								'11'	  => 'Effect 11',
								'12'	  => 'Effect 12',
								'13'	  => 'Effect 13',
								'14'	  => 'Effect 14',
								'15'	  => 'No Effect',
							),
							'value'		  => '1',
						),
	                    array(
							'name'         => 'orderby',
							'label'        => __( 'Order by', 'erado-addons' ),
							'type'         => 'select',
							'options'       => $order_by_values
	                    ),
	                    array(
							'name'         => 'order',
							'label'        => __( 'Order', 'erado-addons' ),
							'desccription' => sprintf( __( 'Designates the ascending or descending order. More at %s.', 'erado-addons' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
							'type'         => 'select',
							'options'       => $order_way_values
	                    ),
                        array(
							'name'        => 'extra_class',
							'label'       => __( 'Extra Class', 'erado-addons' ),
							'type'        => 'text',
						),
					),
					'Slider Settings' => array(
						array(
							'name'        => 'show_hide_carousel',
							'label'       => __( 'Carousel Slider', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'yes'	  => 'Enable',
								'no'	  => 'Disable',
							),
							'value'		  => 'yes',
						),
						array(
							'name'        => 'number_of_rows',
							'label'       => 'Number of rows',
							'description' => __( 'Number of rows.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
                    	array(
							'name'        => 'items_show',
							'label'       => 'Items Show',
							'description' => __( 'Number of Items Show ( > 1199px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '4',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_medium',
							'label'       => 'Items Show On Medium Device.',
							'description' => __( 'Items Show On Medium Device (>= 991px)', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '3',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_tablet',
							'label'       => 'Items Show On Tablet',
							'description' => __( 'Items Show On Tablet Device (>= 768px)', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '2',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_mobile',
							'label'       => 'Items Show On Mobile',
							'description' => __( 'Number of Items Show On Mobile( >= 320px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
						array(
							'name'        => 'items_space',
							'label'       => 'Margin-right(px) on item',
							'admin_label' => true,
							'type' => 'number_slider',  // USAGE RADIO TYPE
							'options' => array(    // REQUIRED
								'min' => 30,
								'max' => 60,
								'unit' => '',
								'show_input' => false
							),
							'value'       => '30',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'show_navigation',
							'label'       => 'Show Navigation',
							'description' => __( 'Show/Hide navigation', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                        'value' => 'show',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'style_navigation',
							'label'       => __( 'Style navigation', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	  => 'Small icon',
								'2'	  => 'Big icon',
							),
							'value'		  => '2',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
						),
	                    array(
							'name'        => 'show_pagination',
							'label'       => 'Show Pagination',
							'description' => __( 'Show/Hide pagination', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'autoplay',
							'label'       => 'Auto Play',
							'description' => __( 'Enable/Disable Auto Play', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'Yes',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'autoplaytimeout',
							'label'       => 'Auto Play Timeout',
							'description' => __( 'Set Auto Play Timeout. Ex: 1000(ms) = 1s.', 'erado-addons' ),
							'type'        => 'text',
	                        'value' => '5000',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'loop',
							'label'       => 'Loop',
							'description' => __( 'Enable/Disable Loop', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'Yes',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'number_of_columns',
							'label'       => 'Number of columns',
							'description' => __( 'Number of cols', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'select',
							'options'      => array(
								'2' => __( '2 Columns', 'erado' ),
			                    '3' => __( '3 Columns', 'erado' ),
			                    '4' => __( '4 Columns', 'erado' ),
								'5' => __( '5 Columns', 'erado' ),
								'6' => __( '6 Columns', 'erado' )
							),
							'value'       => '4',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'no'
						    ),
	                    ),
						array(
							'name'        => 'columns_gap',
							'label'       => 'Columns Gap',
							'description' => __( 'The distance between the columns', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'number_slider',
							'options'     => array(
								'min' 		 => 30,
								'max'        => 60,
								'unit'       => '',
								'show_input' => false
							),
							'value'       => '30',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'no'
						    ),
	                    ),
                    ),
					'Styling' => array(
						array(
							'name' => 'my-css',
							'label' => 'Field Label',
							'type' => 'css',
							'options' => array(
								array(
									'screens' => 'any,1024,999,767,479',
									'Title' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title h3'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title h3'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title h3'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title h3'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title h3'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title h3'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title h3'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => 'addon-title h3'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title h3'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title h3'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title h3'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title h3'),
									),
									'Desciption' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title p'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title p'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title p'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title p'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title p'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title p'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title p'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.addon-title p'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title p'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title p'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title p'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title p'),
									),
									'Tab Name' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.nav-tabs > li > a'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.nav-tabs > li > a'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.nav-tabs > li > a'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.nav-tabs > li > a'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.nav-tabs > li > a'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.nav-tabs > li > a'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.nav-tabs > li > a'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.nav-tabs > li > a'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.nav-tabs > li > a'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.nav-tabs > li > a'),
									),
									'Box' => array(
										array('property' => 'margin', 'label' => 'Margin'),
										array('property' => 'padding', 'label' => 'Padding'),
										array('property' => 'border', 'label' => 'Border'),
									),
								),
							),
						),
					)
				),
			),
            //end product tab
            'kc_product' => array(
				'name'         => 'Product Slider',
				'description'  => __( 'Display product carousel slider', 'erado-addons' ),
				'icon'         => 'jms-icon',
				'category'     => 'JMS Addons',
				'css_box'      => true,
				'is_container' => true,
				'params'       => array(
					'general' => array(
						array(
							'name'        => 'title',
							'label'       => __('Title', 'erado-addons'),
							'type'        => 'text',
							'value'       => '',
						),
						array(
							'name'        => 'description_addon',
							'label'       => 'Desciption Product',
							'description' => __( 'Desciption Product.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'textarea',
							'value'       => ''
	                    ),
						array(
							'name'        => 'total_items',
							'label'       => __( 'Total items', 'erado-addons' ),
							'description' => __( 'Total items', 'erado-addons' ),
							'type'        => 'text',
							'value'       => '12'
						),
	                    array(
							'name'         => 'product_type',
							'label'        => __( 'Product Type', 'erado-addons' ),
							'type'         => 'select',
							'options'       => $product_type
	                    ),
	                    array(
							'name'        => 'product_style',
							'label'       => __( 'Product Style', 'erado-addons' ),
							'type'        => 'radio_image',
							'options'     => array(
								'1' => ERADO_ADDONS_URL . 'assets/images/product/product-style-1.jpg',
								'2' => ERADO_ADDONS_URL . 'assets/images/product/product-style-2.jpg',
							),
							'value'       => '1',
						),
	                    array(
							'name'        => 'hover_image',
							'label'       => __( 'Image Product Effect', 'erado-addons' ),
							'description' => __( 'View demo this <a href="http://localhost/wp/jms_erado/effect-demo/"  target="_blank"> link </a>', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	 	  => 'Effect 1',
								'2'	 	  => 'Effect 2',
								'3'	  	  => 'Effect 3',
								'4'	  	  => 'Effect 4',
								'5'	  	  => 'Effect 5',
								'6'	   	  => 'Effect 6',
								'7'	 	  => 'Effect 7',
								'8'	  	  => 'Effect 8',
								'9'	  	  => 'Effect 9',
								'10'	  => 'Effect 10',
								'11'	  => 'Effect 11',
								'12'	  => 'Effect 12',
								'13'	  => 'Effect 13',
								'14'	  => 'Effect 14',
								'15'	  => 'No Effect',
							),
							'value'		  => '1',
						),
	                    array(
							'name'         => 'orderby',
							'label'        => __( 'Order by', 'erado-addons' ),
							'type'         => 'select',
							'options'       => $order_by_values
	                    ),
	                    array(
							'name'         => 'order',
							'label'        => __( 'Order', 'erado-addons' ),
							'desccription' => sprintf( __( 'Designates the ascending or descending order. More at %s.', 'erado-addons' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
							'type'         => 'select',
							'options'       => $order_way_values
	                    ),
                        array(
							'name'        => 'extra_class',
							'label'       => __( 'Extra Class', 'erado-addons' ),
							'type'        => 'text',
						),
					),
					'Slider Settings' => array(
						array(
							'name'        => 'show_hide_carousel',
							'label'       => __( 'Carousel Slider', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'yes'	  => 'Enable',
								'no'	  => 'Disable',
							),
							'value'		  => 'yes',
						),

						array(
							'name'        => 'number_of_rows',
							'label'       => 'Number of rows',
							'description' => __( 'Number of rows.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
                    	array(
							'name'        => 'items_show',
							'label'       => 'Items Show',
							'description' => __( 'Number of Items Show ( > 1199px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '4',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_medium',
							'label'       => 'Items Show On Medium Device.',
							'description' => __( 'Items Show On Medium Device (>= 991px)', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '3',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_tablet',
							'label'       => 'Items Show On Tablet',
							'description' => __( 'Items Show On Tablet Device (>= 768px)', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '2',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_mobile',
							'label'       => 'Items Show On Mobile',
							'description' => __( 'Number of Items Show On Mobile( >= 480px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
						array(
							'name'        => 'items_space',
							'label'       => 'Margin-right(px) on item',
							'admin_label' => true,
							'type' => 'number_slider',  // USAGE RADIO TYPE
							'options' => array(    // REQUIRED
								'min' => 30,
								'max' => 60,
								'unit' => '',
								'show_input' => false
							),
							'value'       => '30',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'show_navigation',
							'label'       => 'Show Navigation',
							'description' => __( 'Show/Hide navigation', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                        'value' => 'show',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    
	                    array(
							'name'        => 'style_navigation',
							'label'       => __( 'Style navigation', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	  => 'Small icon',
								'2'	  => 'Big icon',
							),
							'value'		  => '2',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
						),

	                    array(
							'name'        => 'show_pagination',
							'label'       => 'Show Pagination',
							'description' => __( 'Show/Hide pagination', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'autoplay',
							'label'       => 'Auto Play',
							'description' => __( 'Enable/Disable Auto Play', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'Yes',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'autoplaytimeout',
							'label'       => 'Auto Play Timeout',
							'description' => __( 'Set Auto Play Timeout. Ex: 1000(ms) = 1s.', 'erado-addons' ),
							'type'        => 'text',
	                        'value' => '5000',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'loop',
							'label'       => 'Loop',
							'description' => __( 'Enable/Disable Loop', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'Yes',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'loadmore',
							'label'       => 'Load more',
							'description' => __( 'Enable/Disable Load more', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'yes',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'no'
						    ),
	                    ),
	                    array(
							'name'        => 'number_of_columns',
							'label'       => 'Number of columns',
							'description' => __( 'Number of cols', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'select',
							'options'      => array(
								'2' => __( '2 Columns', 'erado' ),
			                    '3' => __( '3 Columns', 'erado' ),
			                    '4' => __( '4 Columns', 'erado' ),
								'5' => __( '5 Columns', 'erado' ),
								'6' => __( '6 Columns', 'erado' )
							),
							'value'       => '4',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'no'
						    ),
	                    ),
						array(
							'name'        => 'columns_gap',
							'label'       => 'Columns Gap',
							'description' => __( 'The distance between the columns', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'number_slider',
							'options'     => array(
								'min' 		 => 30,
								'max'        => 60,
								'unit'       => '',
								'show_input' => false
							),
							'value'       => '30',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'no'
						    ),
	                    ),
                    ),
					'Styling' => array(
						//1st field
						array(
							'name' => 'my-css',
							'label' => 'Field Label',
							'type' => 'css',
							'options' => array(
								array(
									'screens' => 'any,1024,999,767,479',
									'Title' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title h3'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title h3'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title h3'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title h3'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title h3'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title h3'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title h3'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => 'addon-title h3'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title h3'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title h3'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title h3'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title h3'),
									),
									'Desciption' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title p'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title p'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title p'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title p'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title p'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title p'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title p'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.addon-title p'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title p'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title p'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title p'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title p'),
									),
									'Box' => array(
										array('property' => 'margin', 'label' => 'Margin'),
										array('property' => 'padding', 'label' => 'Padding'),
										array('property' => 'border', 'label' => 'Border'),
									),
								),
							),
						),
					)
				)
			),
			'kc_product_category' => array(
				'name'         => 'Product Categories Slider',
				'description'  => __( 'Display product carousel slider', 'erado-addons' ),
				'icon'         => 'jms-icon',
				'category'     => 'JMS Addons',
				'css_box'      => true,
				'is_container' => true,
				'params'       => array(
					'general' => array(
						array(
							'name'        => 'title',
							'label'       => __('Title', 'erado-addons'),
							'type'        => 'text',
							'value'       => '',
						),
						array(
							'name'        => 'description_addon',
							'label'       => 'Desciption Product',
							'description' => __( 'Desciption Product.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'textarea',
							'value'       => ''
	                    ),
						array(
							'name'        => 'total_items',
							'label'       => __( 'Total items', 'erado-addons' ),
							'description' => __( 'Total items', 'erado-addons' ),
							'type'        => 'text',
							'value'       => '12'
						),
	                    array(
							'name'         => 'category',
							'label'        => __( 'Product Category', 'erado-addons' ),
							'type'         => 'dropdown',
							'options'       => $term,
	                    ),
	                    array(
							'name'        => 'product_style',
							'label'       => __( 'Product Style', 'erado-addons' ),
							'type'        => 'radio_image',
							'options'     => array(
								'1' => ERADO_ADDONS_URL . 'assets/images/product/product-style-1.jpg',
								'2' => ERADO_ADDONS_URL . 'assets/images/product/product-style-2.jpg',
							),
							'value'       => '1',
						),
	                    array(
							'name'        => 'hover_image',
							'label'       => __( 'Image Product Effect', 'erado-addons' ),
							'description' => __( 'View demo this <a href="http://localhost/wp/jms_erado/effect-demo/"  target="_blank"> link </a>', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	 	  => 'Effect 1',
								'2'	 	  => 'Effect 2',
								'3'	  	  => 'Effect 3',
								'4'	  	  => 'Effect 4',
								'5'	  	  => 'Effect 5',
								'6'	   	  => 'Effect 6',
								'7'	 	  => 'Effect 7',
								'8'	  	  => 'Effect 8',
								'9'	  	  => 'Effect 9',
								'10'	  => 'Effect 10',
								'11'	  => 'Effect 11',
								'12'	  => 'Effect 12',
								'13'	  => 'Effect 13',
								'14'	  => 'Effect 14',
								'15'	  => 'No Effect',
							),
							'value'		  => '1',
						),
	                    array(
							'name'         => 'orderby',
							'label'        => __( 'Order by', 'erado-addons' ),
							'type'         => 'select',
							'options'       => $order_by_values
	                    ),
	                    array(
							'name'         => 'order',
							'label'        => __( 'Order', 'erado-addons' ),
							'desccription' => sprintf( __( 'Designates the ascending or descending order. More at %s.', 'erado-addons' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
							'type'         => 'select',
							'options'       => $order_way_values
	                    ),
                        array(
							'name'        => 'extra_class',
							'label'       => __( 'Extra Class', 'erado-addons' ),
							'type'        => 'text',
						),
					),
					'Slider Settings' => array(
						array(
							'name'        => 'show_hide_carousel',
							'label'       => __( 'Carousel Slider', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'yes'	  => 'Enable',
								'no'	  => 'Disable',
							),
							'value'		  => 'yes',
						),

						array(
							'name'        => 'number_of_rows',
							'label'       => 'Number of rows',
							'description' => __( 'Number of rows.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
                    	array(
							'name'        => 'items_show',
							'label'       => 'Items Show',
							'description' => __( 'Number of Items Show ( > 1199px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '4',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_medium',
							'label'       => 'Items Show On Medium Device.',
							'description' => __( 'Items Show On Medium Device (>= 991px)', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '3',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_tablet',
							'label'       => 'Items Show On Tablet',
							'description' => __( 'Items Show On Tablet Device (>= 768px)', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '2',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'items_mobile',
							'label'       => 'Items Show On Mobile',
							'description' => __( 'Number of Items Show On Mobile( >= 480px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
						array(
							'name'        => 'items_space',
							'label'       => 'Margin-right(px) on item',
							'admin_label' => true,
							'type' => 'number_slider',  // USAGE RADIO TYPE
							'options' => array(    // REQUIRED
								'min' => 30,
								'max' => 60,
								'unit' => '',
								'show_input' => false
							),
							'value'       => '30',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'show_navigation',
							'label'       => 'Show Navigation',
							'description' => __( 'Show/Hide navigation', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                        'value' => 'show',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'style_navigation',
							'label'       => __( 'Style navigation', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	  => 'Small icon',
								'2'	  => 'Big icon',
							),
							'value'		  => '2',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
						),
	                    array(
							'name'        => 'show_pagination',
							'label'       => 'Show Pagination',
							'description' => __( 'Show/Hide pagination', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'show' => 'Show',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'autoplay',
							'label'       => 'Auto Play',
							'description' => __( 'Enable/Disable Auto Play', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'Yes',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'autoplaytimeout',
							'label'       => 'Auto Play Timeout',
							'description' => __( 'Set Auto Play Timeout. Ex: 1000(ms) = 1s.', 'erado-addons' ),
							'type'        => 'text',
	                        'value' => '5000',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'loop',
							'label'       => 'Loop',
							'description' => __( 'Enable/Disable Loop', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
	                            'yes' => 'Yes',
	                        ),
	                        'value' => '',
	                        'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'yes'
						    ),
	                    ),
	                    array(
							'name'        => 'number_of_columns',
							'label'       => 'Number of columns',
							'description' => __( 'Number of cols', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'select',
							'options'      => array(
								'2' => __( '2 Columns', 'erado' ),
			                    '3' => __( '3 Columns', 'erado' ),
			                    '4' => __( '4 Columns', 'erado' ),
								'5' => __( '5 Columns', 'erado' ),
								'6' => __( '6 Columns', 'erado' )
							),
							'value'       => '4',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'no'
						    ),
	                    ),
						array(
							'name'        => 'columns_gap',
							'label'       => 'Columns Gap',
							'description' => __( 'The distance between the columns', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'number_slider',
							'options'     => array(
								'min' 		 => 30,
								'max'        => 60,
								'unit'       => '',
								'show_input' => false
							),
							'value'       => '30',
							'relation' => array(
						        'parent'    => 'show_hide_carousel',
						        'show_when' => 'no'
						    ),
	                    ),
                    ),
					'Styling' => array(
						//1st field
						array(
							'name' => 'my-css',
							'label' => 'Field Label',
							'type' => 'css',
							'options' => array(
								array(
									'screens' => 'any,1024,999,767,479',
									'Title' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title h3'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title h3'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title h3'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title h3'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title h3'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title h3'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title h3'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => 'addon-title h3'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title h3'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title h3'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title h3'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title h3'),
									),
									'Desciption' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title p'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title p'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title p'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title p'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title p'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title p'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title p'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.addon-title p'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title p'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title p'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title p'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title p'),
									),
									'Box' => array(
										array('property' => 'margin', 'label' => 'Margin'),
										array('property' => 'padding', 'label' => 'Padding'),
										array('property' => 'border', 'label' => 'Border'),
									),
								),
							),
						),
					)
				)
			),
			//end kc_product
			'kc_portfolio_list' => array(
				'name'         => 'Portfolio List',
				'description'  => __( 'Display portfolio list', 'erado-addons' ),
				'icon'         => 'jms-icon',
				'category'     => 'JMS Addons',
				'css_box'      => true,
				'is_container' => true,
				'params'       => array(
					'general' => array(
						array(
							'name'        => 'total_items',
							'label'       => __( 'Total items', 'erado-addons' ),
							'description' => __( 'Total items', 'erado-addons' ),
							'type'        => 'text',
							'value'       => '8'
						),
						array(
							'name'        => 'number_of_columns',
							'label'       => 'Number of columns',
							'description' => __( 'Number of cols', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'select',
							'options'      => array(
								'2' => __( '2 Columns', 'erado' ),
			                    '3' => __( '3 Columns', 'erado' ),
			                    '4' => __( '4 Columns', 'erado' )
							),
							'value'       => '4'
	                    ),
	                    array(
							'name'         => 'orderby',
							'label'        => __( 'Order by', 'erado-addons' ),
							'type'         => 'select',
							'options'       => $order_by_values
	                    ),
	                    array(
							'name'         => 'order',
							'label'        => __( 'Order', 'erado-addons' ),
							'desccription' => sprintf( __( 'Designates the ascending or descending order. More at %s.', 'erado-addons' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
							'type'         => 'select',
							'options'       => $order_way_values
	                    ),
                        array(
							'name'        => 'extra_class',
							'label'       => __( 'Extra Class', 'erado-addons' ),
							'type'        => 'text',
						),
					),
					'Styling' => array(
						//1st field
						array(
							'name' => 'my-css',
							'label' => 'Field Label',
							'type' => 'css',
							'options' => array(
								array(
									'screens' => 'any,1024,999,767,479',
									'Box' => array(
										array('property' => 'margin', 'label' => 'Margin'),
										array('property' => 'padding', 'label' => 'Padding'),
										array('property' => 'border', 'label' => 'Border'),
									),
								),
							),
						),
					)
				)
			),
			// End of elemnt kc_sliderlayer
            'kc_testimonialslider' => array(
				'name'        => 'Testimonials Slider',
				'description' => __('Display Testimonial Slider', 'erado-addons'),
				'icon'        => 'jms-icon',
				'category'    => 'JMS Addons',
				'css_box'     => true,
				'is_container' => true,
				'params'      => array(
					'general' => array(
						array(
							'name'        => 'title',
							'label'       => 'Title',
							'admin_label' => true,
							'type'        => 'text',
							'value'       => ''
						),
						array(
							'name'        => 'description_addon',
							'label'       => 'Desciption Product',
							'description' => __( 'Desciption Product.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'textarea',
							'value'       => ''
	                    ),
						array(
							'name'        => 'template',
							'label'       => __('Select Template', 'erado-addons'),
							'type'        => 'select',
							'options'      => array(
                        		'1' => __( 'Style 1', 'erado-addons' ),
                        		'2' => __( 'Style 2', 'erado-addons' ),
                        		'3' => __( 'Style 3', 'erado-addons' ),
                        	),
							'value'       => '1',
						),
						array(
							'name'        => 'total_items',
							'label'       => 'Total Items',
							'description' => __( 'Total Items.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '5'
						),
						array(
							'name'         => 'orderby',
							'label'        => 'Order by',
							'type'         => 'select',
							'options'      => array(
                        		'date'  => __( 'Date', 'erado-addons' ),
                        		'ID'    => __( 'ID', 'erado-addons' ),
                        		'title' => __( 'Title', 'erado-addons' ),
                        		'rand'  => __( 'Random', 'erado-addons' ),
                        	)
						),
						array(
							'name'         => 'order',
							'label'        => 'Order by',
							'desccription' => sprintf( __( 'Designates the ascending or descending order. More at %s.', 'erado-addons' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
							'type'         => 'select',
							'options'       => array(
                        		'DESC' => __( 'Descending', 'erado-addons' ),
                        		'ASC'  => __( 'Ascending', 'erado-addons' )
                        	)
						),
						array(
							'name'        => 'show_image',
							'label'       => 'Show Image',
							'description' => __( 'Show/Hide author image', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
								'show' => 'Show',
							),
							'value' => 'show'
						),
						array(
							'name'        => 'show_office',
							'label'       => 'Show Office',
							'description' => __( 'Show/Hide office', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
								'show' => 'Show',
							),
							'value' => 'show'
						),
                        array(
							'name'        => 'extra_class',
							'label'       => __( 'Extra Class', 'erado-addons' ),
							'type'        => 'text',
						),
					),
					'Slider Settings' => array(
						array(
							'name'        => 'items_show',
							'label'       => 'Items Show',
							'description' => __( 'Number of Items Show ( > 1199px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1'
						),
						array(
							'name'        => 'items_medium',
							'label'       => 'Items Show On Medium Device.',
							'description' => __( 'Items Show On Medium Device.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1'
						),
						array(
							'name'        => 'items_tablet',
							'label'       => 'Items Show On Tablet',
							'description' => __( 'Items Show On Tablet Device.', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1'
						),
						array(
							'name'        => 'items_mobile',
							'label'       => 'Items Show On Mobile',
							'description' => __( 'Number of Items Show On Mobile( >= 320px ).', 'erado-addons' ),
							'admin_label' => true,
							'type'        => 'text',
							'value'       => '1'
						),
						array(
							'name'        => 'items_space',
							'label'       => 'Margin-right(px) on item',
							'admin_label' => true,
							'type' => 'number_slider',
							'options' => array(
								'min' => 30,
								'max' => 60,
								'unit' => '',
								'show_input' => false
							),
							'value'       => '30'
	                    ),
						array(
							'name'        => 'show_navigation',
							'label'       => 'Show Navigation',
							'description' => __( 'Show/Hide navigation', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
								'show' => 'Show',
							),
							'value' => ''
						),
						array(
							'name'        => 'style_navigation',
							'label'       => __( 'Style navigation', 'erado-addons' ),
							'type'        => 'dropdown',
							'options'	  => array(
								'1'	  => 'Small icon',
								'2'	  => 'Big icon',
							),
							'value'		  => '2',
						),
						array(
							'name'        => 'show_pagination',
							'label'       => 'Show Pagination',
							'description' => __( 'Show/Hide pagination', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
								'show' => 'Show',
							),
							'value' => 'show'
						),
						array(
							'name'        => 'autoplay',
							'label'       => 'Auto Play',
							'description' => __( 'Enable/Disable Auto Play', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
								'yes' => 'Yes',
							),
							'value' => 'yes'
						),
						array(
							'name'        => 'autoplaytimeout',
							'label'       => 'Auto Play Timeout',
							'description' => __( 'Set Auto Play Timeout. Ex: 1000(ms) = 1s.', 'erado-addons' ),
							'type'        => 'text',
							'value' => '5000'
						),
						array(
							'name'        => 'loop',
							'label'       => 'Loop',
							'description' => __( 'Enable/Disable Loop', 'erado-addons' ),
							'type'        => 'checkbox',
							'options'     => array(
								'yes' => 'Yes',
							),
							'value' => ''
						),
					),
					'Styling' => array(
						//1st field
						array(
							'name' => 'my-css',
							'label' => 'Field Label',
							'type' => 'css',
							'options' => array(
								array(
									'screens' => 'any,1024,999,767,479',
									'Title' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title h3'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title h3'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title h3'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title h3'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title h3'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title h3'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title h3'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => 'addon-title h3'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title h3'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title h3'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title h3'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title h3'),
									),
									'Desciption' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.addon-title p'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.addon-title p'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.addon-title p'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.addon-title p'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.addon-title p'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.addon-title p'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.addon-title p'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.addon-title p'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.addon-title p'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.addon-title p'),

										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.addon-title p'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.addon-title p'),
									),
									'Image' => array(
										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.image'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.image'),
										array('property' => 'border', 'label' => 'Border', 'selector' => '.image'),
										array('property' => 'width', 'label' => 'Width', 'selector' => '.image'),
										array('property' => 'height', 'label' => 'Height', 'selector' => '.image'),
										array('property' => 'box-shadow', 'label' => 'Box Shadow', 'selector' => '.image'),
										array('property' => 'opacity', 'label' => 'Opacity', 'selector' => '.image'),
									),
									'Comment' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.comment'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.comment'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.comment'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.comment'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.comment'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.comment'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.comment'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.comment'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.comment'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.comment'),
										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.comment'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.comment'),
										array('property' => 'width', 'label' => 'Width', 'selector' => '.comment'),
										array('property' => 'height', 'label' => 'Height', 'selector' => '.comment'),
									),
									'Author' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.author'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.author'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.author'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.author'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.author'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.author'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.author'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.author'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.author'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.author'),
										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.author'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.author'),
										array('property' => 'width', 'label' => 'Width', 'selector' => '.author'),
										array('property' => 'height', 'label' => 'Height', 'selector' => '.author'),
									),
									'Office' => array(
										array('property' => 'color', 'label' => 'Color', 'selector' => '.office'),
										array('property' => 'font-size', 'label' => 'Font Size', 'selector' => '.office'),
										array('property' => 'font-weight', 'label' => 'Font Weight', 'selector' => '.office'),
										array('property' => 'font-style', 'label' => 'Font Style', 'selector' => '.office'),
										array('property' => 'font-family', 'label' => 'Font Family', 'selector' => '.office'),
										array('property' => 'text-align', 'label' => 'Text Align', 'selector' => '.office'),
										array('property' => 'text-transform', 'label' => 'Text Transform', 'selector' => '.office'),
										array('property' => 'text-decoration', 'label' => 'Text Decoration', 'selector' => '.office'),
										array('property' => 'line-height', 'label' => 'Line Height', 'selector' => '.office'),
										array('property' => 'letter-spacing', 'label' => 'Letter Spacing', 'selector' => '.office'),
										array('property' => 'margin', 'label' => 'Margin', 'selector' => '.office'),
										array('property' => 'padding', 'label' => 'Padding', 'selector' => '.office'),
										array('property' => 'width', 'label' => 'Width', 'selector' => '.office'),
										array('property' => 'height', 'label' => 'Height', 'selector' => '.office'),
									),
									'Box' => array(
										array('property' => 'background', 'label' => 'Background'),
										array('property' => 'margin', 'label' => 'Margin'),
										array('property' => 'padding', 'label' => 'Padding'),
										array('property' => 'border', 'label' => 'Border'),
									),
								),
							),
						),
					)
				)
			),
			// End of elemnt kc_testimonial
		)
	);

	$kc->update_map(
		'kc_instagram_feed',
		'params',
		array(
			'general' => array(
				2 => array(
					'name'        => 'columns_style',
					'label'       => __('Number of Columns', 'KingComposer'),
					'type'        => 'select',
					'admin_label' => true,
					'options'      => array(
						'1' => __('1 Columns', 'erado-addons'),
						'2' => __('2 Columns', 'erado-addons'),
						'3' => __('3 Columns', 'erado-addons'),
						'4' => __('4 Columns', 'erado-addons'),
						'5' => __('5 Columns', 'erado-addons'),
						'6' => __('6 Columns', 'erado-addons'),
						'7' => __('7 Columns', 'erado-addons'),
						'8' => __('8 Columns', 'erado-addons')
					),
					'description' => __('Set the photo columns.', 'erado-addons')
				)
			)
		)
	);

}
add_action('init', 'kc_addons_init', 99 );
