<?php
$rd_number = rand();
$el_class = apply_filters( 'kc-el-class', $atts );

extract( $atts );

if ( !empty($extra_class) ) {
    $el_class[] = $extra_class;
}

if ( isset($template) && $template == '1' ) {
    $el_class[] = 'template-1';
} elseif ( isset($template) && $template == '2' ){
    $el_class[] = 'template-2';
}else{
    $el_class[] = 'template-3';
}
if ( isset($style_navigation) && $style_navigation == '2' ) {
    $el_class[] = 'big-arrow';
}
$args = array(
    'post_type'      => 'testimonial',
    'posts_per_page' => ( !empty($total_items) && intval($total_items) ) ? $total_items : 5,
    'orderby'        => $orderby,
    'order'          => $order,
    'post_status'    => 'publish',
);
$testimonials = new WP_Query( $args );
?>

<div id="jmstestimonial-box" class="<?php echo implode(' ', $el_class) ?>">
    <?php if( isset( $title ) && ! empty( $title ) ) : ?>
        <div class="addon-title mb_40">
            <h3><?php echo esc_attr($title); ?></h3>
            <?php if( isset( $description_addon ) && ! empty( $description_addon ) ) : ?>
                <p class="description"><?php echo esc_attr($description_addon); ?></p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
	<div class="testimonial-carousel-<?php echo intval($rd_number); ?> owl-carousel owl-theme">
		<?php
		if ( $testimonials->have_posts() ) {

			while ( $testimonials->have_posts() ) : $testimonials->the_post();
				$office = get_post_meta(get_the_ID(), 'office', true);
				?>
				<div class="item">
                    <?php if ( isset($template) && $template == '1' ) : ?>
    					<div class="testimonial-box">
    						<?php if( $show_image == 'show' ) : ?>
    						<div class="image">
                                <?php if ( has_post_thumbnail() ) {
                    				$img = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
                    				if ( $img[1] >= 80 && $img[2] >= 80 ) {
                    					$image = aq_resize( $img[0], 80, 80, true );
                    					echo '<img src="' . esc_url( $image ) . '" width="80" height="80" alt="' . get_the_title() . '" />';
                    				}
                    			}
                    			?>
    						</div>
    						<?php endif; ?>
    						<div class="comment"><?php the_content(); ?></div>
    						<div class="author"><?php the_title(); ?></div>
                            <?php if( $show_office == 'show' ) : ?>
    							<div class="office"><?php echo esc_attr( $office ); ?>
    						<?php endif; ?></div>
    					</div>
                    <?php endif; ?>

                    <?php if ( isset($template) && $template == '2' ) : ?>
    					<div class="testimonial-box flex middle-xs">
                            <div class="testimonial-info flex middle-xs">
                                <?php if( $show_image == 'show' ) : ?>
        						<div class="image">
                                    <?php if ( has_post_thumbnail() ) {
                        				$img = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
                        				if ( $img[1] >= 75 && $img[2] >= 75 ) {
                        					$image = aq_resize( $img[0], 75, 75, true );
                        					echo '<img src="' . esc_url( $image ) . '" width="75" height="75" alt="' . get_the_title() . '" />';
                        				}
                        			}
                        			?>
        						</div>
        						<?php endif; ?>
                                <div class="author-office">
                                    <div class="author"><?php the_title(); ?></div>
                                    <?php if( $show_office == 'show' ) : ?>
            							<div class="office"><?php echo esc_attr( $office ); ?>
            						<?php endif; ?></div>
                                </div>
                            </div>

                            <div class="testimonial-comment">
                                <div class="comment"><?php the_content(); ?></div>
                            </div>

    					</div>
                    <?php endif; ?>

                    <?php if ( isset($template) && $template == '3' ) : ?>
                        <div class="testimonial-box">
                            <div class="comment"><?php the_content(); ?></div>
                            <div class="info-client">
                                <?php if( $show_image == 'show' ) : ?>
                                <div class="image">
                                    <?php if ( has_post_thumbnail() ) {
                                        $img = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
                                        if ( $img[1] >= 80 && $img[2] >= 80 ) {
                                            $image = aq_resize( $img[0], 80, 80, true );
                                            echo '<img src="' . esc_url( $image ) . '" width="80" height="80" alt="' . get_the_title() . '" />';
                                        }
                                    }
                                    ?>
                                </div>
                                <?php endif; ?>
                                <div class="author-office">
                                    <div class="author"><?php the_title(); ?></div>
                                    <?php if( $show_office == 'show' ) : ?>
                                        <div class="office"><?php echo esc_attr( $office ); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

				</div>
			<?php endwhile; wp_reset_postdata();
		}
		?>
	</div>

</div>

<script type="text/javascript">
	jQuery(document).ready(function($) {
	    var owl_testimonial = $('.testimonial-carousel-<?php echo intval($rd_number); ?>');
		var rtl = false;
    	if ($('body').hasClass('rtl')) rtl = true;

	    owl_testimonial.owlCarousel({
            responsive : {
                320 : {
	        		items: 1,
                    margin: 30
	        	},
				480 : {
	        		items: <?php if( (int) $items_mobile > 0) { echo esc_js($items_mobile); } else { echo '1'; } ?>,
                    margin: 30
	        	},
			    768 : {
			        items: <?php if( (int) $items_tablet > 0) { echo esc_js($items_tablet); } else { echo '1'; } ?>,
                    margin: 30
			    },
			    991 : {
			        items: <?php if( (int) $items_medium > 0) { echo esc_js($items_medium); } else { echo '1'; } ?>,
                    margin: 30
			    },
			    1199 : {
			        items: <?php if( (int) $items_show > 0) { echo esc_js($items_show); } else { echo '1'; } ?>,
			    }
			},
			rtl: rtl,
	        margin: <?php if( (int) $items_space > 0) { echo esc_js($items_space); } else { echo '30'; } ?>,
	        dots: <?php if( $show_pagination == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
	        nav: <?php if( $show_navigation == 'show' ) { echo 'true'; } else { echo 'false'; } ?>,
	        autoplay: <?php if( $autoplay == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
	        loop: <?php if( $loop == 'yes' ) { echo 'true'; } else { echo 'false'; } ?>,
	        autoplayTimeout: <?php if( (int) $autoplaytimeout > 0 ) { echo esc_js($autoplaytimeout); } else { echo '5000'; } ?>,
	        smartSpeed: 1000,
            animateIn: 'fadeIn',
            animateOut: 'fadeOut',
			navText: ['<i class="icon-arrow prev"></i>','<i class="icon-arrow next"></i>']
	    });
	});
</script>
