<?php

    /**
     * ReduxFramework Barebones Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "erado_option";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => false,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Theme Options', 'erado' ),
        'page_title'           => esc_html__( 'Theme Options', 'erado' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => false,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',

        'page_permissions'     => 'administrator',
        // Permissions needed to access the options panel.
        'menu_icon'            => 'dashicons-palmtree',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        //'compiler'             => true,
        //'hide_reset' => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
    $args['share_icons'][] = array(
        'url'   => 'https://facebook.com/joommasters2015',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://twitter.com/joommasters',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.linkedin.com/company/joommasters',
        'title' => 'Find us on LinkedIn',
        'icon'  => 'el el-linkedin'
    );


    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'erado' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'erado' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'erado' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'erado' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'erado' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'General', 'erado' ),
        'id'     => 'general',
        'icon'   => 'el el-dashboard',
        'fields' => array(
            array(
                'id'       => 'login-logo',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__('Control Panel Login Logo', 'erado'),
                'subtitle' => esc_html__('Max width: 302px - Max height: 67px','erado')
            ),
            array(
                'id'      => 'site-loader',
                'type'    => 'switch',
                'title'   => esc_html__('Site Loader', 'erado'),
                'on'      => esc_html__('On','erado'),
                'off'     => esc_html__('Off','erado'),
                'default' => true,
            ),
            array(
                'id'       => 'site-loader-style',
                'type'     => 'select',
                'title'    => esc_html__( 'Site Loader Style', 'erado' ),
                'options'  => array(
                    '1' => esc_html__( 'Style 1', 'erado' ),
                    '2' => esc_html__( 'Style 2', 'erado' ),
                    '3' => esc_html__( 'Style 3', 'erado' ),
                    '4' => esc_html__( 'Style 4', 'erado' ),
                    '5' => esc_html__( 'Style 5', 'erado' ),
                    '6' => esc_html__( 'Style 6', 'erado' ),
                ),
                'default'  => '5',
                'required' => array( 'site-loader', '=', 1 )
            ),
            array(
                'id'       => 'browser-smooth-scroll',
                'type'     => 'switch',
                'title'    => esc_html__('Smooth Browser Scroll', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 0,
            ),
            array(
                'id'       => 'back-to-top',
                'type'     => 'switch',
                'title'    => esc_html__( 'Show Back To Top Button', 'erado' ),
                'desc'     =>  esc_html__( 'Show back to top button.', 'erado' ),
                'on'       => esc_html__( 'On', 'erado' ),
                'off'      => esc_html__( 'Off', 'erado' ),
                'default'  => 1,
            ),
        )
    ) );

    // Top bar
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Top Bar', 'erado' ),
        'id'     => 'top-bar',
        'icon'   => 'el el-circle-arrow-up',
        'fields' => array(
            array(
                'id'          => 'topbar',
                'type'        => 'switch',
                'title'       => esc_html__('Enable Top Bar', 'erado'),
                'default'     => false,
            ),
            array(
                'id'       => 'section-topbar-left-start',
                'type'     => 'section',
                'title'    => esc_html__( 'Top Bar Left', 'erado' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'topbar-phone',
                'type'     => 'text',
                'title'    => esc_html__('Phone', 'erado'),
                'default'  => '01 1 2268 7749'
            ),
            array(
                'id'       => 'topbar-email',
                'type'     => 'text',
                'title'    => esc_html__('Email', 'erado'),
                'default'  => 'Help & Support?'
            ),
            array(
                'id'       => 'topbar-email-link',
                'type'     => 'text',
                'title'    => esc_html__('Link emmail', 'erado'),
                'default'  => '#'
            ),
            array(
                'id'       => 'section-topbar-left-end',
                'type'     => 'section',
                'indent'   => true,
            ),
            //end topbar left
            array(
                'id'       => 'section-topbar-right-start',
                'type'     => 'section',
                'title'    => esc_html__( 'Top Bar Right', 'erado' ),
                'indent'   => true,
            ),
            array(
                'id'          => 'show-account-box',
                'type'        => 'switch',
                'title'       => esc_html__('Show Login/ My Account', 'erado'),
                'default'     => true,
            ),
            array(
                'id'          => 'show-language-box',
                'type'        => 'switch',
                'title'       => esc_html__('Show Language', 'erado'),
                'default'     => false,
            ),
            array(
                'id'          => 'language-name-1',
                'type'        => 'text',
                'title'       => esc_html__('1st Language Name', 'erado'),
                'default'     => 'English',
                'required'    => array( 'show-language-box', '=', 1 )
            ),
            array(
                'id'          => 'language-link-1',
                'type'        => 'text',
                'title'       => esc_html__('1st Language URL', 'erado'),
                'default'     => '#',
                'required'    => array( 'show-language-box', '=', 1 )
            ),
            array(
                'id'          => 'language-name-2',
                'type'        => 'text',
                'title'       => esc_html__('2nd Language Name', 'erado'),
                'default'     => 'Italiano',
                'required'    => array( 'show-language-box', '=', 1 )
            ),
            array(
                'id'          => 'language-link-2',
                'type'        => 'text',
                'title'       => esc_html__('2nd Language URL', 'erado'),
                'default'     => '#',
                'required'    => array( 'show-language-box', '=', 1 )
            ),
            array(
                'id'          => 'language-name-3',
                'type'        => 'text',
                'title'       => esc_html__('3rd Language Name', 'erado'),
                'default'     => '',
                'required'    => array( 'show-language-box', '=', 1 )
            ),
            array(
                'id'          => 'language-link-3',
                'type'        => 'text',
                'title'       => esc_html__('3rd Language URL', 'erado'),
                'default'     => '',
                'required'    => array( 'show-language-box', '=', 1 )
            ),
            array(
                'id'          => 'show-currency-box',
                'type'        => 'switch',
                'title'       => esc_html__('Show Currency', 'erado'),
                'default'     => false,
            ),
            array(
                'id'          => 'show-social-box',
                'type'        => 'switch',
                'title'       => esc_html__('Show Social', 'erado'),
                'default'     => false,
            ),
            array(
                'id'          => 'social-facebook',
                'type'        => 'text',
                'title'       => esc_html__('Facebook', 'erado'),
                'default'     => '#',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-twitter',
                'type'        => 'text',
                'title'       => esc_html__('Twitter', 'erado'),
                'default'     => '#',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-google-plus',
                'type'        => 'text',
                'title'       => esc_html__('Google Plus', 'erado'),
                'default'     => '#',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-pinterest',
                'type'        => 'text',
                'title'       => esc_html__('Pinterest', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-instagram',
                'type'        => 'text',
                'title'       => esc_html__('Instagram', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-vimeo',
                'type'        => 'text',
                'title'       => esc_html__('Vimeo', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-youtube',
                'type'        => 'text',
                'title'       => esc_html__('Youtube', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-dribbble',
                'type'        => 'text',
                'title'       => esc_html__('Dribbble', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-tumblr',
                'type'        => 'text',
                'title'       => esc_html__('Tumblr', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ), 
            array(
                'id'          => 'social-linkedin',
                'type'        => 'text',
                'title'       => esc_html__('Linkedin', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-flickr',
                'type'        => 'text',
                'title'       => esc_html__('Flickr', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-github',
                'type'        => 'text',
                'title'       => esc_html__('Github', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-lastfm',
                'type'        => 'text',
                'title'       => esc_html__('Lastfm', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-paypal',
                'type'        => 'text',
                'title'       => esc_html__('Paypal', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-wordpress',
                'type'        => 'text',
                'title'       => esc_html__('Wordpress', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-skype',
                'type'        => 'text',
                'title'       => esc_html__('Skype', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-reddit',
                'type'        => 'text',
                'title'       => esc_html__('Reddit', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-deviantart',
                'type'        => 'text',
                'title'       => esc_html__('Deviantart', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),
            array(
                'id'          => 'social-steam',
                'type'        => 'text',
                'title'       => esc_html__('Steam', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ), 
            array(
                'id'          => 'social-foursquare',
                'type'        => 'text',
                'title'       => esc_html__('Foursquare', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ), 
            array(
                'id'          => 'social-behance',
                'type'        => 'text',
                'title'       => esc_html__('Behance', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ), 
            array(
                'id'          => 'social-xing',
                'type'        => 'text',
                'title'       => esc_html__('Xing', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ), 
            array(
                'id'          => 'social-stumbleupon',
                'type'        => 'text',
                'title'       => esc_html__('StumbleUpon', 'erado'),
                'default'     => '',
                'required'    => array( 'show-social-box', '=', 1 )
            ),                                                                                                                                                                                              
            array(
                'id'       => 'section-topbar-right-end',
                'type'     => 'section',
                'indent'   => true,
            ),
        )
    ) );

    // Header
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Header', 'erado' ),
        'id'     => 'header',
        'icon'   => 'el el-circle-arrow-up',
        'fields' => array(
            array(
                'id'       => 'header-layout',
                'type'     => 'select',
                'title'    => esc_html__( 'Header Layout', 'erado' ),
                'subtitle' => esc_html__( 'Set the header layout', 'erado' ),
                'options'  => array(
                    '1' => esc_html__( 'Header 1', 'erado' ),
                    '2' => esc_html__( 'Header 2', 'erado' ),
                    '3' => esc_html__( 'Header 3', 'erado' ),
                    '4' => esc_html__( 'Header 4', 'erado' ),
                    '5' => esc_html__( 'Header 5', 'erado' ),
                    '6' => esc_html__( 'Header 6', 'erado' ),
                    '7' => esc_html__( 'Header 7', 'erado' ),
                    '8' => esc_html__( 'Header 8', 'erado' ),
                    '9' => esc_html__( 'Header 9', 'erado' ),
                ),
                'default'  => '1',
            ),
            array(
                'id'       => 'header-fullwidth',
                'type'     => 'switch',
                'title'    => esc_html__('Enable Fullwidth', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 0,
            ),
            array(
                'id'          => 'sticky-header',
                'type'        => 'switch',
                'title'       => esc_html__('Sticky Header', 'erado'),
                'subtitle'    => esc_html__('How to display the header menu on scroll.', 'erado'),
                'default'     => false,
            ),
            array(
                'id'       => 'section-header-left-start',
                'title'    => esc_html__('Header Left', 'erado'),
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'       => 'header-logo',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__('Logo', 'erado'),
            ),
            array(
                'id'       => 'section-header-left-end',
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'       => 'section-header-right-start',
                'title'    => esc_html__('Header Right', 'erado'),
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'          => 'show-search-form',
                'type'        => 'switch',
                'title'       => esc_html__('Show Search Form', 'erado'),
                'default'     => true
            ),
            array(
                'id'          => 'show-cart-button',
                'type'        => 'switch',
                'title'       => esc_html__('Show Cart Button', 'erado'),
                'default'     => true
            ),
            array(
                'id'          => 'show-toggle-sidebar',
                'type'        => 'switch',
                'title'       => esc_html__('Show Toggle Sidebar Button', 'erado'),
                'default'     => true
            ),
            array(
                'id'       => 'section-header-right-end',
                'type'     => 'section',
                'indent'   => true,
            ),
        )
    ) );

    // -> START Footer Fields
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Footer', 'erado' ),
        'id'     => 'footer',
        'icon'   => 'el el-circle-arrow-down',
        'fields' => array(
            array(
                'id'       => 'footer-fullwidth',
                'type'     => 'switch',
                'title'    => esc_html__('Enable Fullwidth', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
                'off'      => esc_html__('Disable', 'erado'),
                'default'  => 0,
            ),
            array(
                'id'       => 'section-footer-top-start',
                'title'    => esc_html__('Footer Top', 'erado'),
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'       => 'footer-top',
                'type'     => 'switch',
                'title'    => esc_html__('Footer Top', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
                'off'      => esc_html__('Disable', 'erado'),
                'default'  => 1,
            ),
            array(
                'id'       => 'footer-column',
                'type'     => 'select',
                'title'    => esc_html__( 'Column Numbers', 'erado' ),
                'subtitle' => esc_html__( 'To edit these contents, please follow this path: Appearance >> Widgets >> Footer Column (Number) ', 'erado' ),
                'options'  => array(
                    '1' => esc_html__( '1', 'erado' ),
                    '2' => esc_html__( '2', 'erado' ),
                    '3' => esc_html__( '3', 'erado' ),
                    '4' => esc_html__( '4', 'erado' ),
                    '6' => esc_html__( '6', 'erado' ),
                ),
                'default'  => '4',
                'required' => array( 'footer-top', '=', 1 )
            ),
            array(
                'id'       => 'footer-column-3',
                'type'     => 'select',
                'title'    => esc_html__( 'Style 3 column', 'erado' ),
                'options'  => array(
                    '1' => esc_html__('4/12 | 4/12 | 4/12', 'erado'),
                    '2'  => esc_html__('3/12 | 6/12 | 3/12', 'erado'),
                    '3'  => esc_html__('6/12 | 3/12 | 3/12', 'erado'),
                    '4'  => esc_html__('3/12 | 3/12 | 6/12', 'erado'),
                ),
                'default'  => '1',
                'required' => array( 'footer-column', '=', '3' )
            ),
            array(
                'id'       => 'footer-column-4',
                'type'     => 'select',
                'title'    => esc_html__( 'Style 4 column', 'erado' ),
                'options'  => array(
                    '1' => esc_html__('3/12 | 3/12 | 3/12 | 3/12', 'erado'),
                    '2'  => esc_html__('4/12 | 2/12 | 3/12 | 3/12', 'erado'),
                    '3'  => esc_html__('4/12 | 2/12 | 4/12 | 2/12', 'erado'),
                    '4'  => esc_html__('4/12 | 4/12 | 2/12 | 2/12', 'erado'),
                    '5'  => esc_html__('4/12 | 2/12 | 2/12 | 4/12', 'erado'),
                    '6'  => esc_html__('3/12 | 3/12 | 2/12 | 4/12', 'erado'),
                ),
                'default'  => '1',
                'required' => array( 'footer-column', '=', '4' )
            ),
            array(
                'id'       => 'section-footer-top-end',
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'       => 'section-footer-bottom-start',
                'title'    => esc_html__('Footer Bottom', 'erado'),
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'       => 'footer-bottom',
                'type'     => 'switch',
                'title'    => esc_html__('Footer bottom', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
                'off'      => esc_html__('Disable', 'erado'),
                'default'  => 1,
            ),
            array(
                'id'       => 'footer-copyright',
                'type'     => 'textarea',
                'title'    => esc_html__('Copyright', 'erado'),
                'subtitle' => esc_html__('HTML is allowed.', 'erado'),
                'validate' => 'html',
                'default'  => 'Copyright 2018. All rights reserved. Design by <a href="#">JoomMasters.com</a>.',
                'required' => array( 'footer-bottom', '=', 1 )
            ),
            array(
                'id'       => 'footer-widget',
                'type'     => 'switch',
                'title'    => esc_html__('Footer Bottom Widgets', 'erado'),
                'subtitle' => esc_html__('To edit this content, please follow this path: Appearance >> Widgets >>  Footer Bottom ','erado'),
                'on'       => esc_html__('Enable', 'erado'),
                'off'      => esc_html__('Disable', 'erado'),
                'default'  => 1,
            ),
            array(
                'id'       => 'footer-payment',
                'type'     => 'switch',
                'title'    => esc_html__('Footer payment', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
                'off'      => esc_html__('Disable', 'erado'),
                'default'  => 0,
                'required' => array( 'footer-bottom', '=', 1 )
            ),
            array(
                'id'       => 'footer-payment-image',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__('Payment Image', 'erado'),
                'subtitle' => esc_html__('Max width: 224px - Max height: 22px','erado'),
                'required' => array( 'footer-payment', '=', 1 ),
            ),
            array(
                'id'       => 'footer-payment-link',
                'type'     => 'text',
                'title'    => esc_html__('Payment Image Link', 'erado'),
                'required' => array( 'footer-payment', '=', 1 ),
            ),

            array(
                'id'       => 'section-footer-top-end',
                'type'     => 'section',
                'indent'   => true,
            ),
        )
    ) );
    /*
     * <--- END SECTIONS
     */

    // BLOG
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Blog', 'erado' ),
        'id'     => 'blog',
        'icon'   => 'el el-shopping-cart',
        'fields' => array()
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Blog List', 'erado' ),
        'id'     => 'blog-list',
        'subsection' => true,
        'fields' => array(
            array(
                'id'       => 'blog-title',
                'type'     => 'text',
                'title'    => esc_html__('Blog Title', 'erado'),
                'default'  => esc_html__('Blog', 'erado')
            ),
            array(
                'id'      => 'blog-background',
                'type'    => 'background',
                'title'   => esc_html__( 'Page Title Background', 'erado' ),
                'default' => array(
                    'background-image'      => '',
                    'background-color'      => ''
                )
            ),
            array(
                'id'       => 'blog-style',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Blog Style', 'erado' ),
                'subtitle' => esc_html__( 'Display blog listing as grid or masonry.', 'erado' ),
                'options'  => array(
                    'list' => array(
                        'alt' => 'List',
                        'img' => ERADO_URL . '/assets/images/layout/list.jpg'
                    ),
                    'grid' => array(
                        'alt' => 'Grid',
                        'img' => ERADO_URL . '/assets/images/layout/grid.jpg'
                    ),
                    'masonry' => array(
                        'alt' => 'Masonry',
                        'img' => ERADO_URL . '/assets/images/layout/masonry.jpg'
                    )
                ),
                'default'  => 'list'
            ),
            array(
                'id'       => 'blog-column',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Blog Column', 'erado' ),
                'options'  => array(
                    '2' => array(
                        'alt' => '2 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/two.jpg'
                    ),
                    '3' => array(
                        'alt' => '3 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/three.jpg'
                    ),
                    '4' => array(
                        'alt' => '4 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/four.jpg'
                    )
                ),
                'default'  => '2',
                'required' => array( 'blog-style', '!=', 'list' )
            ),
            array(
                'id'       => 'blog-pagination-type',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Pagination Type', 'erado' ),
                'options'  => array(
                    'number-pagination' => array(
                        'alt' => 'Number Pagination',
                        'img' => ERADO_URL . '/assets/images/layout/number.jpg'
                    ),
                    'load-more' => array(
                        'alt' => 'Load More',
                        'img' => ERADO_URL . '/assets/images/layout/load-more.jpg'
                    ),
                    'infinite-scroll' => array(
                        'alt' => 'Infinite Scroll',
                        'img' => ERADO_URL . '/assets/images/layout/infinite.jpg'
                    )
                ),
                'default'  => 'number-pagination',
            ),
            array(
                'id'       => 'blog-layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Blog Layout', 'erado' ),
                'subtitle' => esc_html__( 'Select blog layout with sidebar postion.', 'erado' ),
                'options'  => array(
                    'left' => array(
                        'alt' => 'Left Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/left-sidebar.jpg'
                    ),
                    'no' => array(
                        'alt' => 'No Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/no-sidebar.jpg'
                    ),
                    'right' => array(
                        'alt' => 'Right Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/right-sidebar.jpg'
                    ),
                ),
                'default'  => 'left'
            ),
            array(
                'id'       => 'blog-words-or-letters',
                'type'     => 'button_set',
                'title'    => esc_html__('Excerpt length by words or letters', 'erado'),
                'options'  => array(
                    'word'   => esc_html__('Words', 'erado'),
                    'letter' => esc_html__('Letters', 'erado'),
                ),
                'default' => 'letter',
            ),
            array(
                'id'       => 'blog-excerpt-length',
                'type'     => 'text',
                'title'    => esc_html__('Excerpt length', 'erado'),
                'subtitle' => esc_html__('Number of words or letters that will be displayed for each post if you use "Excerpt" mode and don\'t set custom excerpt for each post.', 'erado'),
                'default' => 125,
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Blog Single', 'erado' ),
        'id'     => 'blog-single',
        'subsection' => true,
        'fields' => array(
            array(
                'id'       => 'show-feature-image',
                'type'     => 'switch',
                'title'    => esc_html__('Featured Image', 'erado'),
                'on'       => esc_html__('Show', 'erado'),
				'off'      => esc_html__('Hide', 'erado'),
				'default'  => 1,
            ),
            array(
                'id'       => 'show-related-posts',
                'type'     => 'switch',
                'title'    => esc_html__('Show Related Posts', 'erado'),
                'on'       => esc_html__('Show', 'erado'),
				'off'      => esc_html__('Hide', 'erado'),
				'default'  => 1,
            ),
            array(
                'id'       => 'show-post-navigation',
                'type'     => 'switch',
                'title'    => esc_html__('Show Post Navigation', 'erado'),
                'on'       => esc_html__('Show', 'erado'),
				'off'      => esc_html__('Hide', 'erado'),
				'default'  => 1,
            ),
            array(
                'id'       => 'blog-single-layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Blog Single Layout', 'erado' ),
                'subtitle' => esc_html__( 'Select blog single layout with sidebar postion.', 'erado' ),
                'options'  => array(
                    'left' => array(
                        'alt' => 'Left Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/left-sidebar.jpg'
                    ),
                    'no' => array(
                        'alt' => 'No Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/no-sidebar.jpg'
                    ),
                    'right' => array(
                        'alt' => 'Right Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/right-sidebar.jpg'
                    ),
                ),
                'default'  => 'left'
            ),
        )
    ) );

    // Portfolio
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Portfolio', 'erado' ),
        'id'     => 'portfolio',
        'icon'   => 'el el-filter',
        'fields' => array(
            array(
                'id'       => 'portfolio-title',
                'type'     => 'text',
                'title'    => esc_html__('Portfolio Title', 'erado'),
                'default'  => esc_html__('Portfolio', 'erado')
            ),
            array(
                'id'      => 'portfolio-background',
                'type'    => 'background',
                'title'   => esc_html__( 'Page Title Background', 'erado' ),
                'default' => array(
                    'background-image'      => '',
                    'background-color'      => ''
                )
            ),
            array(
                'id'       => 'portfolio-fullwidth',
                'type'     => 'switch',
                'title'    => esc_html__('Enable Fullwidth', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 0,
            ),
            array(
                'id'       => 'portfolio-style',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Portfolio Style', 'erado' ),
                'options'  => array(
                    'grid' => array(
                        'alt' => 'Grid',
                        'img' => ERADO_URL . '/assets/images/layout/grid.jpg'
                    ),
                    'masonry' => array(
                        'alt' => 'Masonry',
                        'img' => ERADO_URL . '/assets/images/layout/masonry.jpg'
                    )
                ),
                'default'  => 'masonry'
            ),
            array(
                'id'       => 'portfolio-column',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Portfolio Column', 'erado' ),
                'options'  => array(
                    '2' => array(
                        'alt' => '2 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/two.jpg'
                    ),
                    '3' => array(
                        'alt' => '3 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/three.jpg'
                    ),
                    '4' => array(
                        'alt' => '4 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/four.jpg'
                    )
                ),
                'default'  => '3'
            ),
            array(
                'id'       => 'portfolio-number-per-page',
                'type'     => 'text',
                'title'    => esc_html__( 'Per page', 'erado' ),
                'subtitle' => esc_html__( 'How much items per page to show.', 'erado' ),
                'validate' => 'numeric',
                'default'  => '12'
            ),
            array(
                'id'       => 'portfolio-pagination-type',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Pagination Type', 'erado' ),
                'options'  => array(
                    'number-pagination' => array(
                        'alt' => 'Number Pagination',
                        'img' => ERADO_URL . '/assets/images/layout/number.jpg'
                    ),
                    'load-more' => array(
                        'alt' => 'Load More',
                        'img' => ERADO_URL . '/assets/images/layout/load-more.jpg'
                    ),
                    'infinite-scroll' => array(
                        'alt' => 'Infinite Scroll',
                        'img' => ERADO_URL . '/assets/images/layout/infinite.jpg'
                    )
                ),
                'default'  => 'number-pagination',
            )
        )
    ) );

    // Woocommerce
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Woocommerce', 'erado' ),
        'id'     => 'woocommerce',
        'icon'   => 'el el-shopping-cart',
        'fields' => array()
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'General Setting', 'erado' ),
        'id'     => 'wc_general_setting',
        'subsection' => true,
        'fields' => array(
            array(
                'id'          => 'wc-page-title',
                'type'        => 'switch',
                'title'       => esc_html__('Woocommerce Page Title', 'erado'),
                'default'     => true,
            ),
            array(
                'id'      => 'wc-shop-title',
                'type'    => 'text',
                'title'   => esc_html__('Page Title', 'erado'),
                'default' => esc_html__('Shop', 'erado'),
                'required' => array( 'wc-page-title', '=', '1' )
            ),
            array(
                'id'      => 'description-product-related',
                'type'    => 'textarea',
                'title'   => esc_html__('Description Related', 'erado'),
                'default' => esc_html__('Include products updated are similar or are same of quality', 'erado'),
            ),
            array(
                'id'                    => 'wc-shop-background',
                'type'                  => 'background',
                'title'                 => esc_html__( 'Page Title Background', 'erado' ),
                'default'  => array(
                    'background-image'      => '',
                    'background-color'      => ''
                ),
                'required' => array( 'wc-page-title', '=', '1' )
            ),
            array(
                'id'       => 'wc-shop-fullwidth',
                'type'     => 'switch',
                'title'    => esc_html__('Enable Fullwidth', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 0,
            ),
            array(
                'id'       => 'wc-add-to-cart-style',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Add To Cart Style', 'erado' ),
                'options'  => array(
                    'default'        => esc_html__('Default', 'erado'),
                    'toggle-sidebar' => esc_html__('Toggle Sidebar', 'erado'),
                ),
                'default'  => 'default'
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Sub Category Setting', 'erado' ),
        'id'     => 'wc_sub_category_setting',
        'subsection' => true,
        'fields' => array(
            array(
                'id'       => 'wc-sub-category-column',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Woocomerce Column Number', 'erado' ),
                'options'  => array(
                    '2' => array(
                        'alt' => '2 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/two.jpg'
                    ),
                    '3' => array(
                        'alt' => '3 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/three.jpg'
                    ),
                    '4' => array(
                        'alt' => '4 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/four.jpg'
                    ),
                    '6' => array(
                        'alt' => '6 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/six.jpg'
                    )
                ),
                'default'  => '4'
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Product List Setting', 'erado' ),
        'id'     => 'wc_product_list_setting',
        'subsection' => true,
        'fields' => array(
            array(
                'id'       => 'section-shop-action-start',
                'type'     => 'section',
                'title'    => esc_html__( 'Shop Action', 'erado' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'wc-view-mode',
                'type'     => 'switch',
                'title'    => esc_html__('Enable Grid/List', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 1,
            ),
            array(
                'id'       => 'wc-category-tab',
                'type'     => 'switch',
                'title'    => esc_html__('Enable Category Tab', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 0,
            ),
            array(
                'id'       => 'wc-filter',
                'type'     => 'switch',
                'title'    => esc_html__('Enable Filter', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 1,
            ),
            array(
                'id'       => 'wc-filter-style',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Filter Style', 'erado' ),
                'options'  => array(
                    'filter-off-canvas' => esc_html__('Off Canvas Filter', 'erado'),
                    'filter-top'        => esc_html__('Top Filter', 'erado'),
                ),
                'default'  => 'filter-off-canvas',
                'required' => array( 'wc-filter', '=', '1' )
            ),
			array(
                'id'       => 'wc-filter-ajax',
                'type'     => 'switch',
                'title'    => esc_html__('Ajax Filter', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 1,
				'required' => array( 'wc-filter', '=', '1' )
            ),
            array(
                'id'       => 'wc-ordering',
                'type'     => 'switch',
                'title'    => esc_html__('Enable Catalog Ordering', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 0,
				'required' => array( 'wc-filter', '=', '0' )
            ),
            array(
                'id'       => 'section-shop-action-end',
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'       => 'section-shop-information-start',
                'type'     => 'section',
                'title'    => esc_html__( 'Shop Information', 'erado' ),
                'indent'   => true,
            ),
			array(
                'id'       => 'wc-shop-heading',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Shop Heading', 'erado' ),
                'options'  => array(
                    'title_background' => esc_html__('Background Image + Title', 'erado'),
                    'slideshow'        => esc_html__('Slideshow', 'erado'),
					'none'        	 => esc_html__('None', 'erado')
                ),
                'default'  => 'title_background',
                'required' => array( 'wc-filter', '=', '1' )
            ),
            array(
                'id'       => 'wc-product-style',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Product Style', 'erado' ),
                'options'  => array(
                    'style-1' => array(
                        'alt' => 'Product Style 1',
                        'img' => ERADO_URL . '/assets/images/product-style/product-style-1.jpg'
                    ),
                    'style-2' => array(
                        'alt' => 'Product Style 2',
                        'img' => ERADO_URL . '/assets/images/product-style/product-style-2.jpg'
                    ),
                    'style-3' => array(
                        'alt' => 'Product Style 3',
                        'img' => ERADO_URL . '/assets/images/product-style/product-style-3.jpg'
                    ),
                    'style-4' => array(
                        'alt' => 'Product Style 4',
                        'img' => ERADO_URL . '/assets/images/product-style/product-style-4.jpg'
                    ),
                    'style-5' => array(
                        'alt' => 'Product Style 5',
                        'img' => ERADO_URL . '/assets/images/product-style/product-style-5.jpg'
                    ),
                ),
                'default'  => 'style-2'
            ),
            array(
                'id'       => 'wc-quick-view',
                'type'     => 'switch',
                'title'    => esc_html__('Show/Hide Quickview Button', 'erado'),
                'on'       => esc_html__('Show', 'erado'),
				'off'      => esc_html__('Hide', 'erado'),
				'default'  => 1,
            ),
            array(
                'id'       => 'wc-wishlist',
                'type'     => 'switch',
                'title'    => esc_html__('Show/Hide Wishlist', 'erado'),
                'on'       => esc_html__('Show', 'erado'),
				'off'      => esc_html__('Hide', 'erado'),
				'default'  => 1,
            ),
            array(
                'id'       => 'wc-compare',
                'type'     => 'switch',
                'title'    => esc_html__('Show/Hide Compare', 'erado'),
                'on'       => esc_html__('Show', 'erado'),
                'off'      => esc_html__('Hide', 'erado'),
                'default'  => 1,
            ),
            array(
                'id'       => 'wc-category-name',
                'type'     => 'switch',
                'title'    => esc_html__('Show/Hide Category Name', 'erado'),
                'on'       => esc_html__('Show', 'erado'),
				'off'      => esc_html__('Hide', 'erado'),
				'default'  => 1,
            ),
            array(
                'id'       => 'wc-rating',
                'type'     => 'switch',
                'title'    => esc_html__('Show/Hide Rating', 'erado'),
                'on'       => esc_html__('Show', 'erado'),
                'off'      => esc_html__('Hide', 'erado'),
                'default'  => 0,
            ),
            array(
                'id'    => 'show-attribute-variation',
                'type'  => 'switch',
                'title' => esc_html__('Show Attribute Variation','erado'),
                'desc'  => esc_html__('Show attribute variation on product box', 'erado'),
                'on'    => esc_html__('Show','erado'),
				'off'   => esc_html__('Hide','erado'),
				'default' => 1,
            ),
            array(
                'id'       => 'wc-product-hover-style',
                'type'     => 'select',
                'title'    => esc_html__( 'Product Box Hover', 'erado' ),
                'options'  => array(
                    'blur' => esc_html__( 'Image Blur', 'erado' ),
                    'swap' => esc_html__( 'Image Swap', 'erado' ),
                ),
                'default'  => 'swap',
            ),
            array(
                'id'       => 'wc-number-per-page',
                'type'     => 'text',
                'title'    => esc_html__( 'Per page', 'erado' ),
                'subtitle' => esc_html__( 'How much items per page to show.', 'erado' ),
                'validate' => 'numeric',
                'default'  => '12'
            ),
            array(
                'id'       => 'wc-product-column',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Woocomerce Column Number', 'erado' ),
                'options'  => array(
                    '2' => array(
                        'alt' => '2 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/two.jpg'
                    ),
                    '3' => array(
                        'alt' => '3 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/three.jpg'
                    ),
                    '4' => array(
                        'alt' => '4 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/four.jpg'
                    ),
                    '6' => array(
                        'alt' => '6 Columns',
                        'img' => ERADO_URL . '/assets/images/layout/six.jpg'
                    )
                ),
                'default'  => '4'
            ),
            array(
                'id'       => 'wc-archive-style',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Product List Style', 'erado' ),
                'options'  => array(
                    'grid' => array(
                        'alt' => 'Grid',
                        'img' => ERADO_URL . '/assets/images/layout/grid.jpg'
                    ),
                    'masonry' => array(
                        'alt' => 'Masonry',
                        'img' => ERADO_URL . '/assets/images/layout/masonry.jpg'
                    )
                ),
                'default'  => 'grid'
            ),
            array(
                'id'       => 'wc-gutter-space',
                'type'     => 'slider',
                'title'    => esc_html__('Gutter Space','erado'),
                'min'      => 0,
                'max'      => 60,
                'step'     => 5,
                'default'  => 30,
            ),
            array(
                'id'       => 'wc-pagination-type',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Pagination Type', 'erado' ),
                'options'  => array(
                    'number-pagination' => array(
                        'alt' => 'Number Pagination',
                        'img' => ERADO_URL . '/assets/images/layout/number.jpg'
                    ),
                    'load-more' => array(
                        'alt' => 'Load More',
                        'img' => ERADO_URL . '/assets/images/layout/load-more.jpg'
                    ),
                    'infinite-scroll' => array(
                        'alt' => 'Infinite Scroll',
                        'img' => ERADO_URL . '/assets/images/layout/infinite.jpg'
                    )
                ),
                'default'  => 'number-pagination',
            ),
            array(
                'id'       => 'wc-shop-layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Product List Layout', 'erado' ),
                'subtitle' => esc_html__( 'Select shop page layout with sidebar postion.', 'erado' ),
                'options'  => array(
                    'left' => array(
                        'alt' => 'Left Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/left-sidebar.jpg'
                    ),
                    'no' => array(
                        'alt' => 'No Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/no-sidebar.jpg'
                    ),
                    'right' => array(
                        'alt' => 'Right Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/right-sidebar.jpg'
                    ),
                ),
                'default'  => 'no'
            ),
            array(
                'id'       => 'section-shop-information-end',
                'type'     => 'section',
                'indent'   => true,
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Single Product Setting', 'erado' ),
        'id'     => 'wc_single_product_setting',
        'subsection' => true,
        'fields' => array(
            array(
                'id'       => 'wc-single-product-layout',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Product Page Layout', 'erado' ),
                'subtitle' => esc_html__( 'Sidebar position.', 'erado' ),
                'options'  => array(
                    'left' => array(
                        'alt' => 'Left Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/left-sidebar.jpg'
                    ),
                    'no' => array(
                        'alt' => 'No Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/no-sidebar.jpg'
                    ),
                    'right' => array(
                        'alt' => 'Right Sidebar',
                        'img' => ERADO_URL . '/assets/images/layout/right-sidebar.jpg'
                    ),
                ),
                'default'  => 'no',
            ),
            array(
                'id'    => 'sharing-product',
                'type'  => 'switch',
                'title' => esc_html__('Share Social','erado'),
                'desc'  => esc_html__('Show Share Social under product info on single product page', 'erado'),
                'on'    => esc_html__('Show','erado'),
                'off'   => esc_html__('Hide','erado'),
                'default' => 0,
            ),
        )
    ) );

    // START Typography
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Typography', 'erado' ),
        'id'     => 'theme-typography',
        'icon'   => 'el el-font',
        'fields' => array(
            array(
                'id'       => 'section-body-font-start',
                'type'     => 'section',
                'title'    => esc_html__( 'Body Font', 'erado' ),
                'indent'   => true,
            ),
            array(
                'id'       => 'google-charset',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Google Font Character Sets', 'erado' ),
				'desc'     => esc_html__( 'Select google font character sets', 'erado' ),
				'multi'    => true,
                'options'  => array(
                    'cyrillic' 		=> 'Cyrillic',
                    'cyrillic-ext' 	=> 'Cyrillic Extended',
                    'greek' 		=> 'Greek',
					'greek-ext' 	=> 'Greek Extended',
					'latin' 		=> 'Latin',
					'latin-ext' 	=> 'Latin Extneded',
                ),
                'default'  => array('cyrillic','cyrillic-ext','greek','greek-ext','latin-ext','latin'),
            ),
            array(
				'id'          => 'body-font',
				'type'        => 'typography',
				'title'       => esc_html__('Font Family', 'erado'),
                'subtitle'    => esc_html__( 'Specify the body font properties.', 'erado' ),
				'google'      => true,
                'color'       => false,
				'text-align'  => false,
                'line-height' => false,
                'font-style'  => false,
				'subsets'	  => false,
                'letter-spacing' => true,
                'all_styles'  => true,
                'default'        => array(
                    'google'      => true,
                    'font-family' => 'Poppins',
                    'font-size'   => '15',
                    'font-weight' => '400',
                    'letter-spacing' => '0',
                )
			),
            array(
                'id'     => 'section-second-font-start',
                'type'   => 'section',
                'title'  => esc_html__('Second Font', 'erado'),
                'indent' => true
            ),
            array(
				'id'          => 'second-font',
				'type'        => 'typography',
				'title'       => esc_html__('Font Family', 'erado'),
                'subtitle'    => esc_html__('price,..', 'erado'),
                'google'      => true,
                'color'       => false,
				'text-align'  => false,
                'font-weight' => false,
                'font-size'   => false,
                'line-height' => false,
                'font-style'  => false,
				'subsets'	  => false,
                'all_styles'  => true,
                'default'        => array(
                    'font-family' => 'Lato'
                )
			),
            array(
                'id'       => 'section-second-font-end',
                'type'     => 'section',
                'indent'   => true
            ),
            array(
                'id'     => 'section-third-font-start',
                'type'   => 'section',
                'title'  => esc_html__('Third Font', 'erado'),
                'indent' => true
            ),
            array(
                'id'          => 'third-font',
                'type'        => 'typography',
                'title'       => esc_html__('Font Family', 'erado'),
                'subtitle'    => esc_html__('Description products,..', 'erado'),
                'google'      => true,
                'color'       => false,
                'text-align'  => false,
                'font-weight' => true,
                'font-size'   => false,
                'line-height' => false,
                'font-style'  => true,
                'subsets'     => false,
                'all_styles'  => true,
                'default'        => array(
                    'font-family' => 'Playfair Display',
                    'font-style'  => 'italic',
                    'font-weight' => '700',
                )
            ),
            array(
                'id'       => 'section-third-font-end',
                'type'     => 'section',
                'indent'   => true
            ),
            array(
                'id'       => 'section-body-font-end',
                'type'     => 'section',
                'indent'   => true
            ),
            array(
                'id'       => 'section-menu-font-start',
                'type'     => 'section',
                'title'    => esc_html__( 'Menu', 'erado' ),
                'indent'   => true,
            ),
            array(
                'id'             => 'menu-font',
                'type'           => 'typography',
                'title'          => esc_html__( 'Font Family', 'erado' ),
                'google'         => true,
                'text-align'     => false,
                'line-height'    => false,
                'color'          => false,
				'subsets'	     => false,
                'all_styles'     => true,
                'default'        => array(
                    'font-family' => 'Poppins',
                    'font-size'   => '16',
                    'font-weight' => '600',
                )
            ),
            array(
                'id'       => 'section-menu-font-end',
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'       => 'section-heading-font-start',
                'type'     => 'section',
                'title'    => esc_html__( 'Heading', 'erado' ),
                'indent'   => true,
            ),
            array(
                'id'             => 'heading-font',
                'type'           => 'typography',
                'title'          => esc_html__( 'Font Family', 'erado' ),
                'google'         => true,
                'font-style'     => false,
                'font-size'      => false,
                'letter-spacing' => false,
                'text-align'     => false,
                'line-height'    => false,
                'text-transform' => false,
                'color'          => false,
				'subsets'	     => false,
                'all_styles'     => true,
                'default'        => array(
                    'font-family' => 'Poppins',
                    'font-weight' => '600',
                )
            ),
            array(
                'id'             => 'h1-font-size',
                'type'           => 'typography',
                'title'          => esc_html__( 'H1 Font Size', 'erado' ),
                'google'         => true,
                'font-weight'    => false,
                'font-style'     => false,
                'font-family'    => false,
                'letter-spacing' => false,
                'text-align'     => false,
                'line-height'    => false,
                'text-transform' => false,
                'color'          => false,
				'subsets'	     => false,
                'default'        => array(
                    'font-size' => '36'
                )
            ),
            array(
                'id'             => 'h2-font-size',
                'type'           => 'typography',
                'title'          => esc_html__( 'H2 Font Size', 'erado' ),
                'google'         => true,
                'font-weight'    => false,
                'font-style'     => false,
                'font-family'    => false,
                'letter-spacing' => false,
                'text-align'     => false,
                'line-height'    => false,
                'text-transform' => false,
                'color'          => false,
				'subsets'	     => false,
                'default'        => array(
                    'font-size' => '30'
                )
            ),
            array(
                'id'             => 'h3-font-size',
                'type'           => 'typography',
                'title'          => esc_html__( 'H3 Font Size', 'erado' ),
                'google'         => true,
                'font-weight'    => false,
                'font-style'     => false,
                'font-family'    => false,
                'letter-spacing' => false,
                'text-align'     => false,
                'line-height'    => false,
                'text-transform' => false,
                'color'          => false,
				'subsets'	     => false,
                'default'        => array(
                    'font-size' => '24'
                )
            ),
            array(
                'id'             => 'h4-font-size',
                'type'           => 'typography',
                'title'          => esc_html__( 'H4 Font Size', 'erado' ),
                'google'         => true,
                'font-weight'    => false,
                'font-style'     => false,
                'font-family'    => false,
                'letter-spacing' => false,
                'text-align'     => false,
                'line-height'    => false,
                'text-transform' => false,
                'color'          => false,
				'subsets'	     => false,
                'default'        => array(
                    'font-size' => '21'
                )
            ),
            array(
                'id'             => 'h5-font-size',
                'type'           => 'typography',
                'title'          => esc_html__( 'H5 Font Size', 'erado' ),
                'google'         => true,
                'font-weight'    => false,
                'font-style'     => false,
                'font-family'    => false,
                'letter-spacing' => false,
                'text-align'     => false,
                'line-height'    => false,
                'text-transform' => false,
                'color'          => false,
				'subsets'	     => false,
                'default'        => array(
                    'font-size' => '18'
                )
            ),
            array(
                'id'             => 'h6-font-size',
                'type'           => 'typography',
                'title'          => esc_html__( 'H6 Font Size', 'erado' ),
                'google'         => true,
                'font-weight'    => false,
                'font-style'     => false,
                'font-family'    => false,
                'letter-spacing' => false,
                'text-align'     => false,
                'line-height'    => false,
                'text-transform' => false,
                'color'          => false,
				'subsets'	     => false,
                'default'        => array(
                    'font-size' => '16'
                )
            ),
            array(
                'id'       => 'section-heading-font-end',
                'type'     => 'section',
                'indent'   => true,
            ),

        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Color Scheme', 'erado' ),
        'id'     => 'color-scheme',
        'icon'   => 'el el-brush',
        'fields' => array(
            array(
				'id'          => 'primary-color',
				'type'        => 'color',
				'title'       => esc_html__('Primary Color', 'erado'),
				'default'     => '#fe4f18'
			),
            array(
                'id'          => 'primary-color-dark',
                'type'        => 'color',
                'title'       => esc_html__('Color Darken', 'erado'),
                'default'     => '#d83401'
            ),
            array(
				'id'          => 'body-color',
				'type'        => 'color',
				'title'       => esc_html__('Body Color', 'erado'),
				'default'     => '#757575'
			),
            array(
                'id'       => 'section-topbar-style-start',
                'type'     => 'section',
                'title'    => esc_html__( 'Top Bar', 'erado' ),
                'indent'   => true,
            ),
            array(
                'id'      => 'topbar-background',
                'type'    => 'color',
                'title'   => esc_html__('Background', 'erado'),
                'default' => ''
            ),
            array(
                'id'      => 'topbar-border',
                'type'    => 'color',
                'title'   => esc_html__('Border', 'erado'),
                'default' => '#DADADA'
            ),
            array(
                'id'       => 'topbar-color',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Color', 'erado' ),
                'options'  => array(
                    'light' => esc_html__('Light', 'erado'),
                    'dark'  => esc_html__('Dark', 'erado'),
                ),
                'default'  => 'dark'
            ),
            array(
                'id'       => 'section-topbar-style-end',
                'type'     => 'section',
                'indent'   => true,
            ),
            //end topbar style
            array(
                'id'     => 'section-header-style-start',
                'title'  => esc_html__( 'Header', 'erado' ),
                'type'   => 'section',
                'indent' => true,
            ),
            array(
                'id'      => 'header-background',
                'type'    => 'color',
                'title'   => esc_html__( 'Background', 'erado' ),
                'default' => '#fff',
            ),
            array(
                'id'      => 'header-color',
                'type'    => 'color',
                'title'   => esc_html__( 'Color', 'erado' ),
                'default' => '#000',
            ),
            array(
                'id'      => 'header-border',
                'type'    => 'color',
                'title'   => esc_html__( 'Border', 'erado' ),
                'default' => '#f5f5f5',
            ),
            array(
                'id'      => 'header-icon-style',
                'type'    => 'select',
                'title'   => esc_html__( 'Header Icon Style', 'erado' ),
                'options' => array(
                    'inherit' => esc_html__( 'Inherit From Header', 'erado' ),
                    'white'   => esc_html__( 'White Icon', 'erado' ),
                    'black'   => esc_html__( 'Black Icon', 'erado' )
                ),
                'default' => 'inherit'
            ),
            array(
                'id'     => 'section-header-style-end',
                'type'   => 'section',
                'indent' => true,
            ),
            //end header style
            array(
                'id'     => 'section-footer-style-start',
                'title'  => esc_html__( 'Footer', 'erado' ),
                'type'   => 'section',
                'indent' => true,
            ),
            array(
                'id'      => 'footer-background',
                'type'    => 'background',
                'title'   => esc_html__( 'Background', 'erado' ),
                'default' => array(
                    'background-image'      => '',
                    'background-color'      => ''
                ),
            ),
            array(
                'id'      => 'footer-color',
                'type'    => 'color',
                'title'   => esc_html__( 'Color', 'erado' ),
                'default' => '#888'
            ),
            array(
                'id'      => 'widget-title-color',
                'type'    => 'color',
                'title'   => esc_html__( 'Widget Title Color', 'erado' ),
                'default' => '#111111'
            ),
            array(
                'id'      => 'footer-border',
                'type'    => 'color',
                'title'   => esc_html__( 'Border', 'erado' ),
                'default' => '#e9edf0'
            ),
            array(
                'id'     => 'section-footer-style-end',
                'type'   => 'section',
                'indent' => true,
            ),
            //end Footer style
            array(
                'id'       => 'section-heading-color-start',
                'title'    => esc_html__('Heading', 'erado'),
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
				'id'          => 'heading-color',
				'type'        => 'color',
				'title'       => esc_html__('Heading Color', 'erado'),
				'default'     => '#000'
			),
            array(
                'id'       => 'section-heading-color-end',
                'type'     => 'section',
                'indent'   => true,
            ),
        )
    ) );

    // Maintenance
    Redux::setSection( $opt_name, array(
        'title' => esc_html__( 'Maintenance Mode', 'erado' ),
        'id'     => 'maintenance',
        'icon'   => 'el el-time',
        'fields' => array(
            array(
                'id'       => 'maintenance-mode',
                'type'     => 'switch',
                'title'    => esc_html__('Maintenance Mode', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 0,
            ),
            array(
                'id'       => 'section-maintenance-background-start',
                'title'    => esc_html__('Maintenance Background', 'erado'),
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'      => 'maintenance-background',
                'type'    => 'background',
                'title'   => esc_html__( 'Background', 'erado' ),
                'background-color'      => false,
                'default' => array(
                    'background-image'      => '',
                    'background-color'      => ''
                ),
            ),
            array(
                'id'       => 'section-maintenance-background-end',
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'       => 'section-maintenance-text-start',
                'title'    => esc_html__('Maintenance Text', 'erado'),
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'    => 'maintenance-title',
                'type'  => 'text',
                'title' => esc_html__( 'Title', 'erado' ),
                'default' => 'Comming Soon'
            ),
            array(
                'id'    => 'maintenance-message',
                'type'  => 'textarea',
                'title' => esc_html__( 'Message', 'erado' ),
                'default' => 'We are working very hard to give you the best experience with this one. You will love Jms Erado as much as we do. It will morph perfectly on your needs!'
            ),
            array(
                'id'       => 'section-maintenance-text-end',
                'type'     => 'section',
                'indent'   => true,
            ),
            array(
                'id'       => 'maintenance-countdown',
                'type'     => 'switch',
                'title'    => esc_html__('Enable Countdown', 'erado'),
                'on'       => esc_html__('Enable', 'erado'),
				'off'      => esc_html__('Disable', 'erado'),
				'default'  => 0,
            ),
            array(
                'id'       => 'maintenance-date',
                'type'     => 'select',
                'title'    => esc_html__('Date', 'erado'),
                'options'  => array(
                    '01' => '01',
    				'02' => '02',
    				'03' => '03',
    				'04' => '04',
    				'05' => '05',
    				'06' => '06',
    				'07' => '07',
    				'08' => '08',
    				'09' => '09',
    				'10' => '10',
    				'11' => '11',
    				'12' => '12',
    				'13' => '13',
    				'14' => '14',
    				'15' => '15',
    				'16' => '16',
    				'17' => '17',
    				'18' => '18',
    				'19' => '19',
    				'20' => '20',
    				'21' => '21',
    				'22' => '22',
    				'23' => '23',
    				'24' => '24',
    				'25' => '25',
    				'26' => '26',
    				'27' => '27',
    				'28' => '28',
    				'29' => '29',
    				'30' => '30',
    				'31' => '31'
                ),
                'default'  => '15',
                'required' => array( 'maintenance-countdown', '=', 1 )
            ),
            array(
                'id'       => 'maintenance-month',
                'type'     => 'select',
                'title'    => esc_html__('Month', 'erado'),
                'options'  => array(
                    'January'   => 'January',
    				'Febuary'   => 'Febuary',
    				'March'     => 'March',
    				'April'     => 'April',
    				'May'       => 'May',
    				'June'      => 'June',
    				'July'      => 'July',
    				'August'    => 'August',
    				'September' => 'September',
    				'October'   => 'October',
    				'November'  => 'November',
    				'December'  => 'December'
                ),
                'default'  => 'September',
                'required' => array( 'maintenance-countdown', '=', 1 )
            ),
            array(
                'id'       => 'maintenance-year',
                'type'     => 'select',
                'title'    => esc_html__('Year', 'erado'),
                'options'  => array(
                    '2017' => '2017',
    				'2018' => '2018',
    				'2019' => '2019',
    				'2020' => '2020'
                ),
                'default'  => '2017',
                'required' => array( 'maintenance-countdown', '=', 1 )
            ),
        )
    ) );
