<?php

if ( ! function_exists( 'erado_setup' ) ) {
   function erado_setup() {
       load_theme_textdomain( 'erado', get_template_directory() . '/languages' );

       // Add default posts and comments RSS feed links to head.
       add_theme_support( 'automatic-feed-links' );
       add_theme_support( 'title-tag' );
       add_theme_support( 'post-thumbnails' );
       add_theme_support( 'woocommerce' );
       add_theme_support( 'custom-background' );
       add_theme_support( 'custom-header' );
       add_theme_support( 'custom-background' );
       // Add theme support for selective refresh for widgets.
       add_theme_support( 'customize-selective-refresh-widgets' );

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus( array(
            'primary-menu'  => esc_html__('Primary Menu', 'erado'),
            'footer-menu'   => esc_html__('Footer Menu', 'erado')
        ) );

        /*
        * Switch default core markup for search form, comment form, and comments
        * to output valid HTML5.
        */
        add_theme_support( 'html5', array(
           'search-form',
           'comment-form',
           'comment-list',
           'gallery',
           'caption',
        ) );

        add_editor_style(); // add the default style

        if ( ! isset( $content_width ) ) $content_width = 900;
   }
}
add_action( 'after_setup_theme', 'erado_setup' );


/*
* [ Remove all style woocommerce. ] - - - - - - - - - - - - - - - - - - - -
*/
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );

/*
* [ Check variable Theme option ] - - - - - - - - - - - - - - - - - - - -
*/
if ( ! function_exists( 'erado_get_option' ) ) {
    function erado_get_option($name, $default = '') {
        global $erado_option;
        if ( isset($erado_option[$name]) ) {
            return $erado_option[$name];
        }
        return $default;
    }
}

if ( ! function_exists('erado_plugin_active') ) {
    function erado_plugin_active( $plg_class = '', $plg_func = '' ) {
        if($plg_class) return class_exists($plg_class);
        if($plg_func) return function_exists($plg_func);
        return false;
    }
}

if( ! function_exists( 'erado_get_config' ) ) {
    function erado_get_config() {
        $path = ERADO_PATH . '/inc/admin/configs/pages.php';
        if( file_exists( $path ) ) {
            return include $path;
        } else {
            return array();
        }
    }
}

if( ! function_exists( 'erado_recurse_copy' ) ) {
    function erado_recurse_copy($src,$dst) {
        $dir = opendir($src);
        @wp_mkdir_p($dst);
        while(false !== ( $file = readdir($dir)) ) {
            if (( $file != '.' ) && ( $file != '..' )) {
                if ( is_dir($src . '/' . $file) ) {
                    erado_recurse_copy($src . '/' . $file,$dst . '/' . $file);
                } else {
                    copy($src . '/' . $file,$dst . '/' . $file);
                }
            }
        }
        closedir($dir);
    }
}   
/*  Check WooCommerce is activated
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'erado_woocommerce_activated' ) ) {
    function erado_woocommerce_activated() {
        return class_exists( 'woocommerce' ) ? true : false;
    }
}

/*
* [ Register Widget Area. ] - - - - - - - - - - - - - - - - - - - -
*/
if ( ! function_exists( 'erado_register_sidebars' ) ) {
    function erado_register_sidebars() {
        register_sidebar(
            array(
                'name'          => esc_html__( 'Primary Sidebar', 'erado' ),
                'id'            => 'primary-sidebar',
                'description'   => esc_html__( 'The Primary Sidebar', 'erado' ),
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget'  => '</aside>',
                'before_title'  => '<div class="widget-title"> <h3>',
                'after_title'   => '</h3></div>',
            )
        );

        register_sidebar( array(
            'name'          => esc_html__( 'Toggle Sidebar', 'erado' ),
            'id'            => 'toggle-sidebar',
            'description'   => esc_html__( 'Add widgets here to appear in toggle sidebar.', 'erado' ),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title'  => '<div class="widget-title"> <h3>',
            'after_title'   => '</h3></div>',
        ) );

        if ( erado_woocommerce_activated() ) {
            register_sidebar( array(
                'name'          => esc_html__( 'WooCommerce Sidebar', 'erado' ),
                'id'            => 'shop-page',
                'description'   => esc_html__( 'Add widgets here to appear in shop page sidebar.', 'erado' ),
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget'  => '</aside>',
                'before_title'  => '<div class="widget-title"> <h3>',
                'after_title'   => '</h3></div>',
            ) );

            register_sidebar( array(
                'name'          => esc_html__( 'WooCommerce Filter Sidebar', 'erado' ),
                'id'            => 'woocommerce-filter-sidebar',
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget'  => '</aside>',
                'before_title'  => '<div class="widget-title"> <h3>',
                'after_title'   => '</h3></div>',
            ) );
        }

        $footer_column = erado_get_option('footer-column');
        if ( isset($footer_column) ) {
            for ( $i = 1, $n = $footer_column; $i <= $n; $i++ ) {
                register_sidebar(
                    array(
                        'name'          => esc_html__( 'Footer Column ', 'erado' ) . $i,
                        'id'            => 'footer-' . $i,
                        'description'   => sprintf( esc_html__( 'Add widgets here to appear content in column %s on footer', 'erado' ), $i ),
                        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                        'after_widget'  => '</aside>',
                        'before_title'  => '<div class="widget-title"> <h3>',
                        'after_title'   => '</h3></div>',
                    )
                );
            }
        }

        register_sidebar( array(
            'name'          => esc_html__( 'Footer Bottom', 'erado' ),
            'id'            => 'social-footer',
            'description'   => esc_html__( 'Add widgets here to appear Social or Menu on footer bottom ', 'erado' ),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title'  => '<div class="widget-title"> <h3>',
            'after_title'   => '</h3></div>',
        ) );

        register_sidebar( array(
            'name'          => esc_html__( 'Newletter footer', 'erado' ),
            'id'            => 'newletter-footer',
            'description'   => esc_html__( 'Add widgets here to appear Social or Menu on footer bottom ', 'erado' ),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title'  => '<div class="widget-title"> <h3>',
            'after_title'   => '</h3></div>',
        ) );

        register_sidebar( array(
            'name'          => esc_html__( 'Footer Column 1 Demo', 'erado' ),
            'id'            => 'footer-1-4',
            'description'   => esc_html__( 'This widget just for demo.', 'erado' ),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title'  => '<div class="widget-title"> <h3>',
            'after_title'   => '</h3></div>',
        ) );
        
        register_sidebar( array(
            'name'          => esc_html__( 'Footer Column 3 Demo', 'erado' ),
            'id'            => 'footer3-4',
            'description'   => esc_html__( 'This widget just for demo.', 'erado' ),
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title'  => '<div class="widget-title"> <h3>',
            'after_title'   => '</h3></div>',
        ) );

    }
}
add_action( 'widgets_init', 'erado_register_sidebars' );

/*
* [ Add a pingback url auto-discovery header for singularly identifiable articles. ] - - - - - - - - - - - - - - - - - - - -
*/
function erado_pingback_header() {
    if ( is_singular() && pings_open() ) {
        echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
    }
}
add_action( 'wp_head', 'erado_pingback_header' );

/*
* [ Register Google fonts for Erado.. ] - - - - - - - - - - - - - - - - - - - -
*/
if ( ! function_exists( 'erado_fonts_url' ) ) :
    function erado_fonts_url() {
        $fonts_url   = '';
        $fonts       = array();
        $subsets     = '';
        $font_weight = array( 200, 300, 400, 500, 600, 700, 800 );

        $es_fonts   = erado_get_option( 'body-font', array( 'font-family' => 'Poppins', 'google' => true, 'font-weight' => '400', 'font-size' => '15px') );
        $es_subsets = erado_get_option( 'google-charset', array('cyrillic','cyrillic-ext','greek','greek-ext','latin-ext','latin') );

        if( !empty($es_subsets) ) {
            $subsets = implode( ',', $es_subsets );
        }

        if( $es_fonts['google'] == true ) {
            $font_weight = implode( ',', $font_weight );
            $fonts[] = $es_fonts['font-family'] .':'. $font_weight;
            $query_args = array(
                'family' => urlencode( implode( '|', $fonts ) ),
                'subset' => urlencode( $subsets ),
            );
            $fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
        }

        return $fonts_url;
    }
endif;

/*
* [ Enqueue scripts and styles. ] - - - - - - - - - - - - - - - - - - - -
*/
function erado_scripts() {
    wp_dequeue_style( 'yith-wcwl-font-awesome' );
    // Add custom fonts, used in the main stylesheet.
    wp_enqueue_style( 'erado-fonts', erado_fonts_url(), array(), null );
    wp_enqueue_style( 'bootstrap', ERADO_URL . '/assets/3rd-party/bootstrap/css/bootstrap.min.css', array(), '3.3.7');
    wp_enqueue_style( 'pe-icon-7-stroke', ERADO_URL . '/assets/3rd-party/pe-icon-7-stroke/css/pe-icon-7-stroke.css' );
    wp_enqueue_style( 'font-awesome-theme', ERADO_URL . '/assets/3rd-party/font-awesome//css/font-awesome.min.css' );
    wp_enqueue_style( 'owl-carousel', ERADO_URL . '/assets/3rd-party/owl-carousel/owl.carousel.min.css' );
    wp_enqueue_style( 'owl-carousel-theme', ERADO_URL . '/assets/3rd-party/owl-carousel/owl.theme.default.min.css' );
    wp_enqueue_style( 'slick', ERADO_URL . '/assets/3rd-party/slick/slick.css' );
    wp_enqueue_style( 'magnific-popup', ERADO_URL . '/assets/3rd-party/magnific-popup/magnific-popup.css' );
    wp_enqueue_style( 'magnific-popup-effect', ERADO_URL . '/assets/3rd-party/magnific-popup/magnific-popup-effect.css' );

    // Main stylesheet
    wp_enqueue_style( 'erado-style', get_stylesheet_uri() );
    wp_add_inline_style( 'erado-style', erado_custom_css() );

    // Load required scripts.
    wp_enqueue_script( 'bootstrap', ERADO_URL . '/assets/3rd-party/bootstrap/js/bootstrap.min.js', array(), '3.3.7', true);
    wp_enqueue_script( 'isotope' , ERADO_URL . '/assets/3rd-party/isotope/isotope.pkgd.min.js', array(), false, true  );
    wp_enqueue_script( 'owl-carousel', ERADO_URL . '/assets/3rd-party/owl-carousel/owl.carousel.min.js', array(), '2.2.0', true );
    wp_enqueue_script( 'slick', ERADO_URL . '/assets/3rd-party/slick/slick.min.js', array(), '1.5.9', true );
    wp_enqueue_script( 'theia-sticky-sidebar', ERADO_URL . '/assets/3rd-party/theia-sticky-sidebar/theia-sticky-sidebar.js', array(), false, true );
    wp_enqueue_script( 'scrollreveal' , ERADO_URL . '/assets/3rd-party/scrollreveal/scrollreveal.min.js', array(), '3.3.6', true  );
    wp_enqueue_script( 'magnific-popup' , ERADO_URL . '/assets/3rd-party/magnific-popup/jquery.magnific-popup.min.js', array(), false, true  );

    if ( erado_get_option('maintenance-mode', 1) ) {
        wp_enqueue_script( 'countdown' , ERADO_URL . '/assets/3rd-party/countdown/jquery.countdown.min.js', array(), false, true  );
    }
    // Check if browser smooth scroll is enabled
    if ( erado_get_option('browser-smooth-scroll', 0) == 1 ) {
        wp_enqueue_script( 'niceScroll', ERADO_URL . '/assets/3rd-party/nicescroll/jquery.nicescroll.min.js', array(), false, true );
    }
    if ( erado_get_option('sharing-product', 0) == 1 ) {
        if ( function_exists( 'is_product' ) && is_product() ) {
            wp_enqueue_script( 'addthis', '//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-565ea782e30884c0' );
        }
    }
    if ( class_exists( 'WooCommerce' ) ) {
        wp_enqueue_script( 'wc-add-to-cart-variation' );
        wp_enqueue_script( 'jquery-ui-autocomplete' );
        if((int)erado_get_option( 'wc-filter-ajax') == 1 || (isset($_GET['wc-filter-ajax']) && (int)$_GET['wc-filter-ajax'] ==1))
            wp_enqueue_script('erado-shop-filter', ERADO_URL . '/assets/js/shop-filter.js', array(), false, true);
    }

    // Load theme js
    wp_enqueue_script('erado-script', ERADO_URL . '/assets/js/theme.js', array( 'jquery', 'imagesloaded' ), '', true);
    wp_add_inline_script('erado-script', erado_custom_javascript(), 'after');
    wp_add_inline_script( 'erado-script', "var _nonce_erado = '". wp_create_nonce( 'bb_erado' ) ."';");
    wp_add_inline_script( 'erado-script', 'var JmsAjaxURL = "'.esc_js(admin_url('admin-ajax.php')).'"; var JmsSiteURL = "' . home_url() . '/index.php' . '";');

    // Custom localize script
    wp_localize_script( 'erado-script', 'FL_Data_Js',
        array(
            'View Wishlist'    => esc_html__( 'View Wishlist', 'erado' ),
            'viewall_wishlist' => esc_html__( 'View all', 'erado' ),
            'removed_notice'   => esc_html__( '%s has been removed from your cart.', 'erado' ),
            'load_more'        => esc_html__( 'Load more', 'erado' ),
            'no_more_item'     => esc_html__( 'All products loaded.', 'erado' ),
            'days'             => esc_html__( 'days', 'erado' ),
            'hrs'              => esc_html__( 'hrs', 'erado' ),
            'mins'             => esc_html__( 'mins', 'erado' ),
            'secs'             => esc_html__( 'secs', 'erado' ),
            'permalink'        => ( get_option( 'permalink_structure' ) == '' ) ? 'plain' : '',
        )
    );

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

}
add_action( 'wp_enqueue_scripts', 'erado_scripts' );


/*  Hook Javascript
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'erado_custom_javascript' ) ) {
    function erado_custom_javascript() {
        ob_start();

        if( erado_get_option('browser-smooth-scroll', 0) == 1 ) { ?>

            jQuery(document).ready(function($){
                'use strict';
                
                $( 'html' ).niceScroll();
            });

        <?php
        }
        ?>

        <?php
        return ob_get_clean();
    }
}

/*
* [ Add Custom Icon to KingComposer. ] - - - - - - - - - - - - - - - - - - - -
*/
function erado_add_custom_icon() {
    if( function_exists( 'kc_add_icon' ) ) {
        kc_add_icon( ERADO_URL . '/assets/3rd-party/pe-icon-7-stroke/css/pe-icon-7-stroke.css' );
    }
}
add_action('init', 'erado_add_custom_icon');

/*
* [ Adds custom classes to the array of body classes. ] - - - - - - - - - - - - - - - - - - - -
*/
function erado_body_class( $classes ) {

    // Adds a class of group-blog to blogs with more than 1 published author.
    if ( is_multi_author() ) {
        $classes[] = 'group-blog';
    }

    // Adds a class of hfeed to non-singular pages.
    if ( ! is_singular() ) {
        $classes[] = 'hfeed';
    }

    if ( erado_get_option('sticky-header', 0) == 1 ) {
        $classes[] = 'has-sticky-header';
    }

    if ( isset( $_GET['sticky-header'] ) && $_GET['sticky-header'] == 1 ) {
        $classes[] = 'has-sticky-header';
    }

    if ( isset( $_GET['header'] ) && $_GET['header'] == 5 ) {
        $classes[] = 'has-left-header';
    }

    if ( erado_get_option('header-layout') == 5 ) {
        $classes[] = 'has-left-header';
    }

    if ( erado_get_option('wc-add-to-cart-style') == 'toggle-sidebar' ) {
        $classes[] = 'btn-sidebar';
    }else{
        $classes[] = 'btn-cart-default';
    }
    
    // Check if under construction page is enabled
    if ( erado_get_option('maintenance-mode', 1) ) {
        if ( ! is_user_logged_in() ) {
            $classes[] = 'offline';
        }
    }

    return $classes;
}
add_filter( 'body_class', 'erado_body_class' );

/**
 * Redirect to under construction page
 */
if ( ! function_exists( 'erado_offline' ) ) {
    function erado_offline() {
        $maintenance_mode = erado_get_option('maintenance-mode', 0);

        // Check if under construction page is enabled
        if ( $maintenance_mode ) {

            if ( ! is_feed() ) {
                // Check if user is not logged in
                if ( ! is_user_logged_in() ) {
                    // Load under construction page
                    include get_template_directory() . '/maintenance.php';
                    exit;
                }
            }

            // Check if user is logged in
            if ( is_user_logged_in() ) {
                global $current_user;

                // Get user role
                wp_get_current_user();

                $loggedInUserID = $current_user->ID;
                $userData = get_userdata( $loggedInUserID );

                // If user role is not 'administrator' then redirect to under construction page
                if ( 'administrator' != $userData->roles[0] ) {
                    if ( ! is_feed() ) {
                        include get_template_directory() . '/maintenance.php';
                        exit;
                    }
                }
            }
        }
    }
}
add_action( 'template_redirect', 'erado_offline' );

 /*     Preloader Style
 /* --------------------------------------------------------------------- */
if ( ! function_exists( 'erado_preloader' ) ) {
    function erado_preloader() {
        $preloader_style = erado_get_option('site-loader-style', 1);
        ?>
        <div class="preloader">
            <div class="spinner<?php echo esc_attr( $preloader_style ); ?>">
                <div class="dot1"></div>
                <div class="dot2"></div>
                <div class="bounce1"></div>
                <div class="bounce2"></div>
                <div class="bounce3"></div>
            </div>
        </div>
        <?php
    }
}


/*  Render Header Layout
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'erado_header' ) ) {
    function erado_header() {
        $layout = erado_get_option( 'header-layout', 1 );
        $sticky_header = erado_get_option( 'sticky-header', 1 );

        if ( isset($_GET['header']) && $_GET['header'] == 1 ) {
            $layout = 1;
        } elseif ( isset($_GET['header']) && $_GET['header'] == 2 ) {
            $layout = 2;
        } elseif ( isset($_GET['header']) && $_GET['header'] == 3 ) {
            $layout = 3;
        } elseif ( isset($_GET['header']) && $_GET['header'] == 4 ) {
            $layout = 4;
        } elseif ( isset($_GET['header']) && $_GET['header'] == 5 ) {
            $layout = 5;
        } elseif ( isset($_GET['header']) && $_GET['header'] == 6 ) {
            $layout = 6;
        }elseif ( isset($_GET['header']) && $_GET['header'] == 7 ) {
            $layout = 7;
        }elseif ( isset($_GET['header']) && $_GET['header'] == 8 ) {
            $layout = 8;
        }elseif ( isset($_GET['header']) && $_GET['header'] == 9 ) {
            $layout = 9;
        }

        if ( isset($_GET['sticky-header']) && $_GET['sticky-header'] == 1 ) {
            $sticky_header = 1;
        }

        if ( $sticky_header == 1 ) {
            echo '<div class="sticky-header-height"></div>';
        }

        get_template_part( 'views/header/header', $layout );
    }
}

/*  Render Footer Layout
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'footer_layout' ) ) {
    function erado_footer() {
        $layout = erado_get_option( 'footer-layout', 1 );
        if ( isset($_GET['footer']) && $_GET['footer'] == 1 ) {
            $layout = 1;
        } elseif ( isset($_GET['footer']) && $_GET['footer'] == 2 ) {
            $layout = 2;
        } elseif ( isset($_GET['footer']) && $_GET['footer'] == 3 ) {
            $layout = 3;
        } elseif ( isset($_GET['footer']) && $_GET['footer'] == 4 ) {
            $layout = 4;
        } elseif ( isset($_GET['footer']) && $_GET['footer'] == 5 ) {
            $layout = 5;
        }elseif ( isset($_GET['footer']) && $_GET['footer'] == 6 ) {
            $layout = 6;
        }
        get_template_part( 'views/footer/footer', $layout );
    }
}

/*  Render Footer Social
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'erado_social' ) ) {
    function erado_social() {
        $facebook    = erado_get_option( 'social-facebook' );
        $twitter     = erado_get_option( 'social-twitter' );
        $googleplus  = erado_get_option( 'social-google-plus' );
        $pinterest   = erado_get_option( 'social-pinterest' );
        $instagram   = erado_get_option( 'social-instagram' );
        $vimeo       = erado_get_option( 'social-vimeo' );
        $youtube     = erado_get_option( 'social-youtube' );
        $dribbble    = erado_get_option( 'social-dribbble' );
        $tumblr      = erado_get_option( 'social-tumblr' );
        $linkedin    = erado_get_option( 'social-linkedin' );
        $flickr      = erado_get_option( 'social-flickr' );
        $github      = erado_get_option( 'social-github' );
        $lastfm      = erado_get_option( 'social-lastfm' );
        $paypal      = erado_get_option( 'social-paypal' );
        $wordpress   = erado_get_option( 'social-wordpress' );
        $skype       = erado_get_option( 'social-skype' );
        $reddit      = erado_get_option( 'social-reddit' );
        $deviantart  = erado_get_option( 'social-deviantart' );
        $steam       = erado_get_option( 'social-steam' );
        $foursquare  = erado_get_option( 'social-foursquare' );
        $behance     = erado_get_option( 'social-behance' );
        $xing        = erado_get_option( 'social-xing' );
        $stumbleupon = erado_get_option( 'social-stumbleupon' );
        ?>
        <ul class="social-icons">
            <?php if ( ! empty($facebook) ) : ?>
                <li><a href="<?php echo esc_url($facebook); ?>"><i class="fa fa-facebook"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($twitter) ) : ?>
                <li><a href="<?php echo esc_url($twitter); ?>"><i class="fa fa-twitter"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($googleplus) ) : ?>
                <li><a href="<?php echo esc_url($googleplus); ?>"><i class="fa fa-google-plus"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($pinterest) ) : ?>
                <li><a href="<?php echo esc_url($pinterest); ?>"><i class="fa fa-pinterest"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($instagram) ) : ?>
                <li><a href="<?php echo esc_url($instagram); ?>"><i class="fa fa-instagram"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($vimeo) ) : ?>
                <li><a href="<?php echo esc_url($vimeo); ?>"><i class="fa fa-vimeo"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($youtube) ) : ?>
                <li><a href="<?php echo esc_url($youtube); ?>"><i class="fa fa-youtube"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($dribbble) ) : ?>
                <li><a href="<?php echo esc_url($dribbble); ?>"><i class="fa fa-dribbble"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($tumblr) ) : ?>
                <li><a href="<?php echo esc_url($tumblr); ?>"><i class="fa fa-tumblr"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($linkedin) ) : ?>
                <li><a href="<?php echo esc_url($linkedin); ?>"><i class="fa fa-linkedin"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($flickr) ) : ?>
                <li><a href="<?php echo esc_url($flickr); ?>"><i class="fa fa-flickr"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($github) ) : ?>
                <li><a href="<?php echo esc_url($github); ?>"><i class="fa fa-github"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($lastfm) ) : ?>
                <li><a href="<?php echo esc_url($lastfm); ?>"><i class="fa fa-lastfm"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($paypal) ) : ?>
                <li><a href="<?php echo esc_url($paypal); ?>"><i class="fa fa-paypal"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($wordpress) ) : ?>
                <li><a href="<?php echo esc_url($wordpress); ?>"><i class="fa fa-wordpress"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($skype) ) : ?>
                <li><a href="<?php echo esc_url($skype); ?>"><i class="fa fa-skype"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($reddit) ) : ?>
                <li><a href="<?php echo esc_url($reddit); ?>"><i class="fa fa-reddit"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($deviantart) ) : ?>
                <li><a href="<?php echo esc_url($deviantart); ?>"><i class="fa fa-deviantart"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($steam) ) : ?>
                <li><a href="<?php echo esc_url($steam); ?>"><i class="fa fa-steam"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($foursquare) ) : ?>
                <li><a href="<?php echo esc_url($foursquare); ?>"><i class="fa fa-foursquare"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($behance) ) : ?>
                <li><a href="<?php echo esc_url($behance); ?>"><i class="fa fa-behance"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($xing) ) : ?>
                <li><a href="<?php echo esc_url($xing); ?>"><i class="fa fa-xing"></i></a></li>
            <?php endif; ?>

            <?php if ( ! empty($stumbleupon) ) : ?>
                <li><a href="<?php echo esc_url($stumbleupon); ?>"><i class="fa fa-stumbleupon"></i></a></li>
            <?php endif; ?>

        </ul>
        <?php
    }
}
/*  Footer Payment
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'erado_payment' ) ){
    function erado_payment(){?>
        <?php $footer_payment_image = erado_get_option('footer-payment-image');
        if( !empty( $footer_payment_image['url'] ) ) : ?>
            <img src="<?php echo esc_url( $footer_payment_image['url'] );?>" alt="<?php bloginfo( 'name' ); ?>">
        <?php else:?>
            <img src="<?php echo ERADO_URL . '/assets/images/payment.png'; ?>" alt="<?php bloginfo( 'name' ); ?>">
        <?php endif;?>
        <?php
    }
}


/*  Header Logo
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'erado_logo' ) ){
    function erado_logo(){?>
        <?php $header_logo = erado_get_option('header-logo');
        if( !empty( $header_logo['url'] ) ) : ?>
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                <img src="<?php echo esc_url( $header_logo['url'] );?>" alt="<?php bloginfo( 'name' ); ?>">
            </a>
        <?php else:?>
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                <img src="<?php echo ERADO_URL . '/assets/images/logo.png'; ?>" alt="<?php bloginfo( 'name' ); ?>">
            </a>
        <?php endif;?>
        <?php
    }
}

/*  Hook Javascript
/* --------------------------------------------------------------------- */
if ( ! function_exists( 'erado_custom_javascript' ) ) {
    function erado_custom_javascript() {
        $data = array();
        $data[] = erado_get_option( 'custom-js' );
        return preg_replace( '/\n|\t/i', '', implode( '', $data ) );
    }
}

/**
 * Create a breadcrumb menu.
 *
 * @return string
 */
if ( ! function_exists( 'erado_breadcrumb' ) ) {
    function erado_breadcrumb() {
        // Settings
        $sep   = '<span></span>';
        $home  = esc_html__( 'Home', 'erado' );
        $blog  = esc_html__( 'Blog', 'erado' );
        $shop  = esc_html__( 'Shop', 'erado' );

        // Get the query & post information
        global $post, $wp_query;

        // Get post category
        $category = get_the_category();

        // Get product category
        $product_cat = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

        if ( $product_cat ) {
            $tax_title = $product_cat->name;
        }

        $output = '';

        // Build the breadcrums
        $output .= '<div class="breadcrumb">';

        // Do not display on the homepage
        if ( ! is_front_page() ) {

            if ( ( function_exists( 'is_shop' ) && is_shop() ) || ( function_exists( 'is_product' ) && is_product() ) || function_exists( 'is_product_category' ) && is_product_category() || function_exists( 'is_product_tag' ) && is_product_tag() ) {
                do_action('erado_woocommerce_breadcrumb');
            } elseif ( is_home() ) {

                // Home page
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= $sep;
                $output .= $blog;
            } elseif ( is_post_type_archive() ) {
                $post_type = get_post_type_object( get_post_type() );
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                $output .= $post_type->labels->singular_name;
            } elseif ( is_tax() ) {
                $term = $GLOBALS['wp_query']->get_queried_object();
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                $output .= $term->name;
            } elseif ( is_single() ) {
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                // Single post (Only display the first category)
                if ( ! empty( $category ) ) {
                    $output .= '<a href="' . esc_url( get_category_link( $category[0]->term_id ) ) . '" title="' . esc_attr( $category[0]->cat_name ) . '">' . $category[0]->cat_name . '</a>';
                    $output .= ' ' . $sep . ' ';
                }
                $output .= get_the_title();

            } elseif ( is_category() ) {
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                $thisCat = get_category( get_query_var( 'cat' ), false );
                if ( $thisCat->parent != 0 ) echo get_category_parents( $thisCat->parent, TRUE, ' ' );

                // Category page
                $output .= single_cat_title( '', false );

            } elseif ( is_page() ) {
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';

                // Standard page
                if ( $post->post_parent ) {

                    // If child page, get parents
                    $anc = get_post_ancestors( $post->ID );

                    // Get parents in the right order
                    $anc = array_reverse($anc);

                    // Parent page loop
                    foreach ( $anc as $ancestor ) {
                        $parents = '<a href="' . esc_url( get_permalink( $ancestor ) ) . '" title="' . esc_attr( get_the_title( $ancestor ) ) . '">' . get_the_title( $ancestor ) . '</a>';
                        $parents .= ' ' . $sep . ' ';
                    }

                    // Display parent pages
                    $output .= $parents;

                    // Current page
                    $output .= get_the_title();

                } else {

                    // Just display current page if not parents
                    $output .= get_the_title();

                }

            } elseif ( is_tag() ) {

                // Tag page

                // Get tag information
                $term_id  = get_query_var( 'tag_id' );
                $taxonomy = 'post_tag';
                $args     = 'include=' . $term_id;
                $terms    = get_terms( $taxonomy, $args );

                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                // Display the tag name
                $output .= $terms[0]->name;

            } elseif ( is_day() ) {
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                // Day archive

                // Year link
                $output .= '<a href="' . esc_url( get_year_link( get_the_time( 'Y' ) ) ) . '" title="' . esc_attr( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . esc_html__( ' Archives', 'erado' ) . '</a>';
                $output .= ' ' . $sep . ' ';

                // Month link
                $output .= '<a href="' . esc_url( get_month_link( get_the_time('Y'), get_the_time( 'm' ) ) ) . '" title="' . esc_attr( get_the_time( 'M' ) ) . '">' . get_the_time( 'M' ) . esc_html__( ' Archives', 'erado' ) . '</a';
                $output .= ' ' . $sep . ' ';

                // Day display
                $output .= get_the_time('jS') . ' ' . get_the_time('M') . esc_html__( ' Archives', 'erado' );

            } elseif ( is_month() ) {
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                // Month Archive

                // Year link
                $output .= '<a href="' . esc_url( get_year_link( get_the_time( 'Y' ) ) ) . '" title="' . esc_attr( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . esc_html__( ' Archives', 'erado' ) . '</a>';
                $output .= ' ' . $sep . ' ';

                // Month display
                $output .= get_the_time( 'M' ) . esc_html__( ' Archives', 'erado' );

            } elseif ( is_year() ) {
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                // Display year archive
                $output .= get_the_time('Y') . esc_html__( 'Archives', 'erado' );

            } elseif ( is_author() ) {
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                // Auhor archive

                // Get the author information
                global $author;
                $userdata = get_userdata( $author );

                // Display author name
                $output .= esc_html__( 'Author: ', 'erado' ) . $userdata->display_name;

            } elseif ( get_query_var('paged') ) {
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                // Paginated archives
                $output .= esc_html__( 'Page', 'erado' ) . ' ' . get_query_var( 'paged' );

            } elseif ( is_search() ) {
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                // Search results page
                $output .= esc_html__( 'Search results for: ' . get_search_query(),'erado' );

            } elseif ( is_404() ) {

                // 404 page
                $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
                $output .= ' ' . $sep . ' ';
                $output .= esc_html__( 'Error 404', 'erado' );
            }

        } else  {
            $output .= '<a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $home ) . '">' . esc_attr( $home ) . '</a>';
            $output .= ' ' . $sep . ' ';
            $output .= esc_html__( 'Front Page', 'erado' );
        }

        $output .= '</div>';

        return apply_filters( 'erado_breadcrumb', $output );
    }
}

if ( ! function_exists( 'erado_breadcrumbs' ) ) {

    /**
     * Output the WooCommerce Breadcrumb.
     *
     * @param array $args Arguments.
     */
    function erado_breadcrumbs( $args = array() ) {
        $args = wp_parse_args( $args, apply_filters( 'woocommerce_breadcrumb_defaults', array(
            'delimiter'   => '&nbsp;<span></span>&nbsp;',
            'wrap_before' => '<nav class="woocommerce-breadcrumb">',
            'wrap_after'  => '</nav>',
            'before'      => '',
            'after'       => '',
            'home'        => _x( 'Home', 'breadcrumb', 'erado' ),
        ) ) );

        $breadcrumbs = new WC_Breadcrumb();

        if ( ! empty( $args['home'] ) ) {
            $breadcrumbs->add_crumb( $args['home'], apply_filters( 'woocommerce_breadcrumb_home_url', home_url() ) );
        }

        $args['breadcrumb'] = $breadcrumbs->generate();

        /**
         * WooCommerce Breadcrumb hook
         *
         * @hooked WC_Structured_Data::generate_breadcrumblist_data() - 10
         */
        do_action( 'erado_breadcrumbs', $breadcrumbs, $args );

        wc_get_template( 'global/breadcrumb.php', $args );
    }
}

/**
 * Filter portfolio limit per page.
 */
function erado_portfolio_per_page( $query ) {
    if ( ! is_post_type_archive( 'portfolio' ) ) return;

    // Get portfolio number per page
    $limit = erado_get_option( 'portfolio-number-per-page' );
    if ( $query->query_vars['post_type'] == 'portfolio' ) {
        $query->query_vars['posts_per_page'] = $limit;
    }

    return $query;
}
add_filter( 'pre_get_posts', 'erado_portfolio_per_page' );

if ( ! function_exists( 'erado_toggle_box' )  ) {
    function erado_toggle_box() {
        $header_icon = erado_get_option('header-icon-style', 'inherit');
        if ( isset( $_GET['header_icon'] ) && $_GET['header_icon'] == 'white' ) {
            $header_icon = 'white';
        }

        ?>
        <div class="btn-group" id="toggle-box">
            <a href="javascript:void(0)" class="toggle-sidebar">
                <?php if ( $header_icon == 'white' ) : ?>
                    <i class="icon-menu light"></i>
                <?php elseif ( $header_icon == 'black' ) : ?>
                    <i class="icon-menu"></i>
                <?php else : ?>
                    <i class="icon-menu"></i>
                <?php endif; ?>


            </a>
        </div>
        <?php
    }
}

/**
 * Language Dropdown
 */

if ( ! function_exists( 'erado_language' )  ) {
    function erado_language() {

        $language_name_1 = erado_get_option( 'language-name-1' );
        $language_name_2 = erado_get_option( 'language-name-2' );
        $language_name_3 = erado_get_option( 'language-name-3' );
        $language_link_1 = erado_get_option( 'language-link-1' );
        $language_link_2 = erado_get_option( 'language-link-2' );
        $language_link_3 = erado_get_option( 'language-link-3' );

        $output = '';
        if ( $language_link_1 ||  $language_link_2 || $language_link_3 ) {

            $output .= '<div class="btn-group compact-hidden">';
                if ( $language_link_1 ) {
                    $output .= '<a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown">'. esc_attr( $language_name_1 ) .'</a>';
                }

                $output .= '<div class="dropdown-menu dropdown-language">';
                    $output .= '<ul>';
                        if ( $language_link_1 ) {
                            $output .= '<li><a href="' . esc_url( $language_link_1 ) . '">'. esc_attr( $language_name_1 ) .'</a></li>';
                        }
                        if ( $language_link_2 ) {
                            $output .= '<li><a href="' . esc_url( $language_link_2 ) . '">'. esc_attr( $language_name_2 ) .'</a></li>';
                        }
                        if ( $language_link_3 ) {
                            $output .= '<li><a href="' . esc_url( $language_link_3 ) . '">'. esc_attr( $language_name_3 ) .'</a></li>';
                        }
                    $output .= '</ul>';
                $output .= '</div>';

            $output .= '</div>';

        }

        return apply_filters( 'erado_language', $output );
    }
}

/*---------------------------------
    Custom Login Logo
------------------------------------*/
if ( ! function_exists( 'erado_login_logo' ) ) {
    function erado_login_logo() {
        $login_logo = erado_get_option('login-logo');

        $login_logo_url = ( isset($login_logo['url']) && $login_logo['url'] ) ? $login_logo['url'] : ERADO_URL . '/assets/images/logo.png';
        echo '<style type="text/css"> h1 a { background: url(' . esc_url($login_logo_url) . ') center no-repeat !important; width:302px !important; height:67px !important; } </style>';
    }
}
add_action('login_head', 'erado_login_logo');

function erado_script_admin() {
    wp_enqueue_style( 'erado-custom-wp-admin', ERADO_URL . '/assets/css/admin-style.css', false, '1.0.0' );
}
add_action('admin_enqueue_scripts', 'erado_script_admin');
