<?php
$portfolio_container_class = '';
$portfolio_fullwidth       = erado_get_option( 'portfolio-fullwidth', 0 );

if ( $portfolio_fullwidth == 0 ) {
	$portfolio_container_class = 'container';
} else {
	$portfolio_container_class = 'portfolio-fullwidth pl_60 pr_60';
}

get_header(); ?>
<div class="fl-page-content">
	<?php get_template_part( 'views/page-heading/style', 1 ); ?>
	<div class="container mt_85 mb_85">
		<div class="row">
			<div id="main-content" class="col-lg-9 col-md-9 col-sm-8 col-xs-12">
				<?php while ( have_posts() ) : the_post(); ?>
					<?php the_content(); ?>
				<?php endwhile; ?>
			</div>
			<!-- end content -->
			<div id="main-sidebar" class="col-lg-3 col-md-3 col-sm-4 col-xs-12">
				<?php the_title('<h1 class="portfolio-title">', '</h1>'); ?>
				<?php
					$desc = get_post_meta( get_the_ID(), 'portfolio-desc', true );

					if ( ! empty( $desc ) ) {
						echo '<p class="portfolio-desc mb_25">' . esc_attr( $desc ) . '</p>';
					}
				?>
				<div class="portfolio-meta">
					<div class="db"><span><?php echo esc_html__( 'Categories: ', 'erado-addons' ); ?></span><?php echo get_the_term_list( $post->ID, 'portfolio_cat', '', ', ' ); ?></div>
					<div class="db"><span><?php echo esc_html__( 'Clients: ', 'erado-addons' ); ?></span><?php echo get_the_term_list( $post->ID, 'portfolio_client', '', ', ' ); ?></div>
					<div class="db"><span><?php echo esc_html__( 'Tags: ', 'erado-addons' ); ?></span><?php echo get_the_term_list( $post->ID, 'portfolio_tag', '', ', ' ); ?></div>
				</div>
			</div>
		</div>
		<div class="clearfix"></div>
		<?php Erado_Addons_Portfolio::related(); ?>

	</div>
</div>
<?php get_footer(); ?>
