<?php
$rd_number = rand();
$el_class = apply_filters( 'kc-el-class', $atts );

extract( $atts );

if ( !empty($extra_class) ) {
    $el_class[] = $extra_class;
}

$el_class[] = 'jmsportfolio';

?>

<div class="<?php echo implode(' ', $el_class) ?>">
    <?php
    if( ! empty( $total_items ) ) {
        $limit = esc_attr($total_items);
    } else {
        $limit = -1;
    }

    $columns = esc_attr($number_of_columns);

    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

    // Filter portfolio post type
    $args = array(
        'post_type'      => 'portfolio',
        'post_status'    => 'publish',
        'orderby'        => $orderby,
    	'order'          => $order,
        'posts_per_page' => $limit,
        'paged'          => $paged
    );

    $query = new WP_Query( $args );
?>
    <div class="portfolio-row row portfolio-layout erado-masonry portfolios" data-masonry='{"selector":".item","layoutMode":"masonry"}'>
        <?php while ( $query->have_posts() ) : $query->the_post(); ?>
            <?php
                // Get portfolio category
                $categories = wp_get_post_terms( get_the_ID(), 'portfolio_cat' );

                if ( $columns == 2 ) {
                    $classes = array( 'col-md-6 item pr mb_30' );
                } elseif( $columns == 3 ) {
                    $classes = array( 'col-md-4 item pr mb_30' );
                } elseif( $columns == 4 ) {
                    $classes = array( 'col-md-3 item pr mb_30' );
                }
            ?>
            <div id="portfolio-<?php the_ID(); ?>" class="col-sm-6 col-xs-12 <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
                <div class="item-animation">
                    <div class="portfolio-item-inner pr<?php if ( ! has_post_thumbnail() ) echo ' no-thumb'; ?>">
                        <?php if ( has_post_thumbnail() ) : ?>
                            <div class="portfolio-thumbnail oh">
                                <?php the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) ); ?>
                            </div>
                        <?php endif; ?>
                        <div class="portfolio-content tc pa">
                            <div class="portfolio-text-wrapper">
                                <div class="portfolio-text-inner">
                                    <a class="link dib" href="<?php the_permalink(); ?>"><i class="pe-7s-link"></i></a>
                                    <?php the_title('<h4 class="entry-title">', '</h4>'); ?>
                                    <?php if ( isset($categories) ) {
                                        echo '<div class="portfolio-category">' . get_the_term_list( get_the_ID(), 'portfolio_cat', '', ', ' ) . '</div>';
                                    } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
    </div>
    <div class="clearfix"></div>
</div>
