<?php
if ( !class_exists( 'WooCommerce' ) ) return;

$rd_number = rand();
$el_class = apply_filters( 'kc-el-class', $atts );

extract( $atts );

if ( !empty($extra_class) ) {
    $el_class[] = $extra_class;
}

$el_class[] = 'jmsproductlist';

if ( !empty($productbox_style) ) {
    $el_class[] = 'product-box-style-' . $productbox_style;
}

if ( !empty($number_of_columns) ) {
    $el_class[] = 'product-col-' . $number_of_columns;
}

// Magin wrapper
$product_list = array();
$product_list[] = 'product-list-wrapper';
if ( !empty($columns_gap) ) {
    $product_list[] = 'ml_-' . ceil($columns_gap / 2) . ' mr_-' . ceil($columns_gap / 2);
}

// Padding Item
$item_class = array();
$item_class[] = 'item-wrapper';
if ( !empty($columns_gap) ) {
    $item_class[] = 'pl_' . ceil($columns_gap / 2) . ' pr_' . ceil($columns_gap / 2);
}

if ( (!empty($productbox_style) && $productbox_style == 2 ) && $columns_gap > 0 ) {
    $item_class[] = 'mb_' . $columns_gap;
}



$meta_query   = WC()->query->get_meta_query();
$meta_query[] = array(
    'key'   => '_featured',
    'value' => 'yes'
);

// Global Query
$args = array(
    'post_type'				=> 'product',
    'post_status'			=> 'publish',
    'ignore_sticky_posts'	=> 1,
    'posts_per_page' 		=> $total_items,
);
$args['meta_query'] = WC()->query->get_meta_query();
$tax_query   		= WC()->query->get_tax_query();

//recent products
if( isset( $product_type ) && ( $product_type == 'recent-product' ) ) {
    $args['orderby'] 	= $orderby;
    $args['order'] 		= $order;
    $args['tax_query']	= $tax_query;

    $products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );
}

//featured products
if( isset( $product_type ) && ( $product_type == 'featured-product' ) ) {

    $tax_query[] = array(
        'taxonomy' => 'product_visibility',
        'field'    => 'name',
        'terms'    => 'featured',
        'operator' => 'IN',
    );

    $args['orderby'] 	= $orderby;
    $args['order'] 		= $order;
    $args['tax_query']	= $tax_query;
    $products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );

}

//best selling
if( isset( $product_type ) && ( $product_type == 'best-seller-product' ) ):
    $args['orderby'] 	= $orderby;
    $args['order'] 		= $order;
    $args['meta_key'] 	= 'total_sales';
    $args['orderby'] 	= 'meta_value_num';
    $args['tax_query']	= $tax_query;

    $products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );

endif;

//sale products
if( isset( $product_type ) && ( $product_type == 'sale-product' ) ):

    $product_ids_on_sale = wc_get_product_ids_on_sale();
    $args['orderby']     = $orderby;
    $args['order']       = $order;
    $args['tax_query']   = $tax_query;
    $args['post__in']    = array_merge( array( 0 ), $product_ids_on_sale );

    $products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );

endif;

?>
<div class="<?php echo implode(' ', $el_class) ?>">
	<div class="<?php echo implode(' ', $product_list); ?>">
		<?php if ( $products->have_posts() ) :?>
			<?php while ( $products->have_posts() ) : $products->the_post(); ?>
                <div class="<?php echo implode(' ', $item_class); ?>">
                    <?php wc_get_template_part( 'content', 'product' ); ?>
                </div>
			<?php endwhile; // end of the loop. ?>
		<?php endif;
		wp_reset_postdata();?>
	</div>
</div>
