<?php
if ( !class_exists( 'WooCommerce' ) ) return;

$rd_number = rand();
$el_class = apply_filters( 'kc-el-class', $atts );

extract( $atts );

if ( !empty($extra_class) ) {
    $el_class[] = $extra_class;
}

$el_class[] = 'jmsproducttabcat';

// Magin wrapper
$product_tab_cat = array();
$product_tab_cat[] = 'product-cat-wrapper';

// Padding Item
$item_class = array();
$item_class[] = 'item';

if ( isset($number_of_columns) && $number_of_columns == 6 ) {
	$item_class[] = 'mb_65 col-lg-2 col-md-3 col-sm-4 col-xs-6';
} elseif ( isset($number_of_columns) && $number_of_columns == 5 ) {
	$item_class[] = 'mb_65 item-5 col-md-3 col-sm-4 col-xs-6';
} elseif ( isset($number_of_columns) && $number_of_columns == 4 ) {
	$item_class[] = 'mb_65 col-md-3 col-sm-4 col-xs-6';
} elseif( isset($number_of_columns) && $number_of_columns == 3 ) {
	$item_class[] = 'mb_65 col-md-4 col-sm-4 col-xs-6';
} elseif ( isset($number_of_columns) && $number_of_columns == 2 ) {
	$item_class[] = 'mb_65 col-md-6 col-sm-4 col-xs-6';
}

//Get all product categories
$cat_args = array(
    'taxonomy'     => 'product_cat',
    'orderby'      => 'name',
    'show_count'   => 0,
    'pad_counts'   => 0,
    'hierarchical' => 0,
    'title_li'     => '',
    'parent'       => 0,
    'hide_empty'   => 0,
);

$product_categories = get_terms( 'product_cat', $cat_args );
$count = count($product_categories);
$shop_page_url = get_permalink( wc_get_page_id( 'shop' ) );
?>
<div class="<?php echo implode(' ', $el_class) ?>">
    <div class="product-cat-filter clearfix mb_40">
        <ul class="cat-filter-menu">
            <li class="shop-categories-btn"><a href="#"><?php echo esc_attr_e('Categories', 'erado'); ?></a></li>
            <li class="shop-filter-btn"><a href="#"><?php echo esc_attr_e('Filter', 'erado'); ?></a></li>
        </ul>
        <ul class="category-tab">
            <li class="current-cat">
                <a href="<?php echo $shop_page_url; ?>" data-class="<?php echo implode(' ', $item_class) ?>">
                    <?php echo esc_html__( 'All', 'erado' ); ?>
                </a>
            </li>
        <?php
        if ( $count > 0 ) {
            foreach ($product_categories as $cat) {
                ?>
                <li>
                    <a href="<?php echo get_term_link($cat->slug, 'product_cat'); ?>">
                        <?php echo $cat->name; ?>
                    </a>
                </li>
                <?php
            }
        }
        ?>
        </ul>
        <input type="hidden" name="current_url" id="current_url" value="<?php echo $shop_page_url; ?>" />
    </div>
    <div class="shop-filter-top">
        <?php if ( is_active_sidebar( 'woocommerce-filter-sidebar' ) ) : ?>
        <div class="filter-top clearfix">
            <?php
            dynamic_sidebar( 'woocommerce-filter-sidebar' );
            ?>
        </div>
        <?php endif; ?>
    </div>

	<div class="<?php echo implode(' ', $product_tab_cat); ?>">
        <div class="inner">
            <?php
            $args = array(
    	        'post_type'           => 'product',
    	        'post_status'         => 'publish',
    	        'ignore_sticky_posts' => 1,
    	        'orderby'             => $orderby,
    	        'order'               => $order,
    	        'meta_query'          => WC()->query->get_meta_query(),
    	        'posts_per_page'      => $total_items,
    	    );
    	    $products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );

    		if ( $products->have_posts() ) :
    			while ( $products->have_posts() ) : $products->the_post(); ?>
                    <div class="<?php echo implode(' ', $item_class) ?>">
                        <?php wc_get_template_part( 'content', 'product' ); ?>
                    </div>
    			<?php endwhile; // end of the loop. ?>
    		<?php endif;
    		wp_reset_postdata();
            ?>
        </div>
	</div>
</div>
