<?php
    $topBar            = erado_get_option('topbar', 0);
    $topBarStyle       = (erado_get_option( 'topbar-color' ) == 'light') ? 'light' : 'dark';
    $topBarPhone       = erado_get_option( 'topbar-phone', '01 1 2268 7749' );
    $topBarEmail       = erado_get_option( 'topbar-email', 'eradocare@demo.com' );
    $topBarEmailLink   = erado_get_option( 'topbar-email-link', '#' );
    $topBarAccount     = erado_get_option( 'show-account-box', 1 );
    $topBarLanguage    = erado_get_option( 'show-language-box', 0 );
    $topBarCurrency    = erado_get_option( 'show-currency-box', 0 );
    $topBarSocial      = erado_get_option( 'show-social-box', 0 );
    $showSearchForm    = erado_get_option('show-search-form', 1);
    $showCartButton    = erado_get_option('show-cart-button', 1);
    $showToggleSidebar = erado_get_option('show-toggle-sidebar', 1);

    $header_container  = erado_get_option( 'header-fullwidth', 0 );

    $header_icon_class = erado_get_option('header-icon-style', 'inherit');
    if ( isset( $_GET['header_icon'] ) && $_GET['header_icon'] == 'white' ) {
        $header_icon_class = 'white';
    }

    // Header container
    $header_container_class = '';
    if ( $header_container == 0 ) {
        $header_container_class = 'container';
    } else {
        $header_container_class = 'container-fluid';
    }

    if ( isset($_GET['header_container']) && $_GET['header_container'] == 0 ) {
        $header_container_class = 'container';
    } elseif ( isset($_GET['header_container']) && $_GET['header_container'] == 1 ) {
        $header_container_class = 'container-fluid';
    }

    if ( isset($_GET['topbar']) && $_GET['topbar'] == 1 ) {
        $topBar = 1;
    } elseif ( isset($_GET['topbar']) && $_GET['topbar'] == 0 ) {
        $topBar = 0;
    }
?>
<header id="header-wrapper" class="header-1">
    <?php if ( $topBar == 1 ) : ?>
        <div class="top-header <?php echo esc_attr($topBarStyle); ?>">
            <div class="<?php echo esc_attr( $header_container_class ); ?>">
                <div class="header-row row">
                    <div class="header-position col-lg-6 col-md-6 col-sm-12 col-xs-12 topheader-left">
                        <?php
                        if ( ! empty($topBarPhone) ) {
                            echo '<div class="header-block">';
                            echo apply_filters( 'erado_post_meta', '<p>' . esc_html__( 'Call:', 'erado' ) . ' ' . esc_attr( $topBarPhone ) . '</p>' );
                            echo '</div>';
                        }
                        ?>

                        <?php if ( ! empty($topBarEmail) ) { ?>
                            <div class="header-block">
                                <a href="<?php echo esc_attr( $topBarEmailLink ) ?>">
                                    <?php echo apply_filters( 'erado_post_meta', esc_attr( $topBarEmail ) );
                                     ?>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="header-position col-lg-6 col-md-6 hidden-sm hidden-xs tr topheader-right">
                        <?php if ( class_exists( 'WooCommerce' ) && $topBarAccount == 1 ) : ?>
                            <div class="header-block">
                                <?php echo erado_my_account(); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ( $topBarLanguage ): ?>
                            <div class="header-block">
                                <?php echo erado_language(); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ( class_exists( 'WooCommerce' ) && $topBarCurrency == 1 ) : ?>
                            <div class="header-block">
                                <?php echo erado_currency(); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- top-header -->
    <?php endif; ?>

    <div class="main-header pt_35 pb_35">
        <div class="<?php echo esc_attr( $header_container_class ); ?>">
            <div class="header-row flex middle-xs">
                <div class="header-position hidden-lg hidden-md menu-toggle pt_7">
                    <div class="header-block">
                        <div class="menu-button">
                            <i class="icon-menu"></i>
                        </div>
                    </div>
                </div>
                <div class="header-position header-logo">
                    <div class="header-block">
                        <?php erado_logo(); ?>
                    </div>
                </div>
                <!-- header-logo -->
                <div class="header-position header-position-center hidden-sm hidden-xs main-navigation tc">
                    <div class="header-block">
                        <?php if ( has_nav_menu('primary-menu') ) : ?>
                            <?php
                                $menu = array(
                                    'theme_location'  => 'primary-menu',
                                    'container_class' => 'primary-menu-wrapper',
                                    'menu_class'      => 'primary-menu',
                                );
                                wp_nav_menu( $menu );
                            ?>
                        <?php else : ?>
                            <div class="primary-menu-wrapper">
                                <ul class="primary-menu">
                                    <li><a href="<?php echo esc_url(home_url( '/' )) . 'wp-admin/nav-menus.php?action=locations'; ?>"><?php _e( 'Select or create a menu', 'erado' ) ?></a></li>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <!-- main-navigation -->
                <div class="header-position header-action pt_7 <?php echo esc_attr( $header_icon_class ); ?>">
                    <?php if ( $showSearchForm ) : ?>
                        <div class="header-block hidden-sm hidden-xs">
                            <div class="btn-group" id="header-search">
                                <a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown">
                                    <i class="icon-search"></i>
                                </a>
                                <div class="search-box">
                                    <?php get_search_form(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ( class_exists( 'WooCommerce' ) && $showCartButton ) : ?>
                        <div class="header-block">
                            <?php erado_header_cart(); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ( $showToggleSidebar ) : 
                        if (is_active_sidebar( 'toggle-sidebar' )) {
                    ?>
                        <div class="header-block hidden-sm hidden-xs">
                            <?php echo erado_toggle_box(); ?>
                        </div>
                    <?php 
                        }
                        endif; 
                    ?>
                </div>
                <!-- header-action -->
            </div>
        </div>
    </div>
</header>
