<?php
$shop_title = $blog_title = '';

$show_page_title = 'show';
if ( get_post_meta ( get_the_ID(), 'show-page-title', true ) ) {
    $show_page_title = get_post_meta ( get_the_ID(), 'show-page-title', true );
}

$shop_title           = erado_get_option('wc-shop-title', 'Shop');
$blog_title           = erado_get_option('blog-title', 'Blog');
$page_not_found_title = erado_get_option('404-title', '404');
$portfolio_title      = erado_get_option('portfolio-title', 'Portfolio');

if( isset($show_page_title) && $show_page_title == 'show' ) : ?>
    <?php if( ! is_single() ) : ?>
    	<div class="page-heading pt_50 pb_50">
    		<div class="container">
    			<div class="row">
                    <div class="page-heading-position tc">
                        <?php
    		                if ( function_exists( 'is_shop' ) && is_shop() ) {
    		                    echo '<h2 class="page-title">'. esc_attr( $shop_title ) .'</h2>';
    						} elseif ( is_404() ) {
    		                    echo '<h2 class="page-title">'. esc_attr( $page_not_found_title ) .'</h2>';
    						} elseif ( is_home() ) {
    							echo '<h2 class="page-title">'. esc_attr( $blog_title ) .'</h2>';
    		                } elseif ( is_post_type_archive( 'portfolio' ) ) {
    		                    echo '<h2 class="page-title">' . esc_attr( $portfolio_title ) . '</h2>';
    		                } elseif ( is_archive() ) {
    		                    echo '<h2 class="page-title">' . single_cat_title( '', false ) . '</h2>';
                            } elseif ( is_search() ) {
                                echo '<h2 class="page-title">' . esc_html__('Search Results','erado') . '</h2>';
    		                } else {
    		                    the_title( '<h2 class="page-title">', '</h2>' );
    		                }
    		            ?>
                    </div>
    				<div class="page-heading-position tc">
    					<?php
    						if ( erado_woocommerce_activated() && is_woocommerce() ){
    							echo erado_breadcrumbs();
    						} else {
    							echo erado_breadcrumb();
    						}
    					?>
    				</div>
    			</div>
    		</div>
    	</div>
    <?php else : ?>
        <div class="page-heading pt_28 pb_28">
            <div class="container">
        		<?php
        	        if ( erado_woocommerce_activated() && is_woocommerce() ){
        	            echo erado_breadcrumbs();
        	        } else {
        	            echo erado_breadcrumb();
        	        }
        	    ?>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
