<?php
$blog_column = erado_get_option( 'blog-column', '2' );

// DEMO
if ( isset( $_GET['column'] ) && $_GET['column'] == 2 ) {
	$blog_column = 2;
} elseif ( isset( $_GET['column'] ) && $_GET['column'] == 3 ) {
	$blog_column = 3;
} elseif ( isset( $_GET['column'] ) && $_GET['column'] == 4 ) {
	$blog_column = 4;
}


if ( $blog_column == 2 ) {
	$class = 'item col-lg-6 col-md-6 col-sm-6 col-xs-12 mb_40';
} elseif ( $blog_column == 3 ) {
	$class = 'item col-lg-4 col-md-4 col-sm-6 col-xs-12 mb_40';
} elseif ( $blog_column == 4 ) {
	$class = 'item col-lg-3 col-md-3 col-sm-6 col-xs-12 mb_40';
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( esc_attr($class) ); ?>>
	<div class="post-inner item-animation">
        <div class="post-thumbnail pr">
            <?php if ( has_post_thumbnail() ) : ?>
            <a href="<?php esc_url( the_permalink() ); ?>" class="db mb_20" rel="bookmark" title="<?php the_title(); ?>">
				<?php
					$img = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
					if ( class_exists('Aq_Resize') && $img[1] >= 277 && $img[2] >= 197 ) {
						$image = aq_resize( $img[0], 600, 400, true ); ?>
						<img class="111" src="<?php echo esc_url( $image ); ?>" width="600" height="400" alt="<?php the_title(); ?>" />
					<?php } else { ?>
						<img class="222" src="<?php echo esc_url( $img[0] ); ?>" alt=" <?php echo get_the_title(); ?>" />
					<?php } ?>
            </a>
            <?php endif; ?>
        </div>
        <div class="post-content">
			<?php
				erado_post_title();
				erado_post_meta();
			?>
		</div><!-- .post-content -->
        <div class="post-excerpt">
            <?php erado_post_excerpt( 24 ); ?>
             <?php erado_get_content(); ?>
        </div>

	</div>
</article><!-- #post-# -->
