<?php
/**
 * Add to wishlist template
 *
 * @author Your Inspiration Themes
 * @package YITH WooCommerce Wishlist
 * @version 2.0.0
 */

if ( ! defined( 'YITH_WCWL' ) ) {
	exit;
} // Exit if accessed directly

global $product;
?>

<div class="yith-wcwl-add-to-wishlist add-to-wishlist-<?php echo esc_attr($product_id); ?>">
	<?php if( ! ( $disable_wishlist && ! is_user_logged_in() ) ): ?>
	    <div class="yith-wcwl-add-button pr <?php if( $exists && ! $available_multi_wishlist ){
	    		echo esc_attr('hide', 'erado');
	    		}else{
	    		echo esc_attr('show', 'erado');
	    	}
	    	?>">
	        <?php yith_wcwl_get_template( 'add-to-wishlist-' . $template_part . '.php', $atts ); ?>
	    </div>

		<div class="yith-wcwl-remove-button pr yith-wcwl-wishlistaddedbrowse <?php if( $exists && ! $available_multi_wishlist ){
	    		echo esc_attr('show', 'erado');
	    		}else{
	    		echo esc_attr('hide', 'erado');
	    	}
	    	?>">
		   <a class="button" href="<?php echo esc_url( $wishlist_url )?>" data-product-id="<?php echo esc_attr( $product_id ) ?>">
			   <i class="fa-heart2"></i><span class="text-hidden"><?php esc_html_e('Remove from Wishlist', 'erado'); ?></span>
		   </a>
		   <span class="ajax-loading visible-hide"><i class="fa fa-spinner spinner"></i></span>
	   </div>

	    <div class="yith-wcwl-wishlistaddresponse"></div>
	<?php else: ?>
		<a href="<?php echo esc_url( add_query_arg( array( 'wishlist_notice' => 'true', 'add_to_wishlist' => $product_id ), get_permalink( wc_get_page_id( 'myaccount' ) ) ) )?>" class="<?php echo str_replace( 'add_to_wishlist', '', $link_classes ) ?>" >
			<i class="fa fa-heart-o"></i><span class="text-hidden"><?php esc_html_e('Add to wishlist', 'erado'); ?></span>
		</a>
	<?php endif; ?>
</div>
