<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

$next     = get_adjacent_post();
$previous = get_adjacent_post( false, '', false );

if ( isset($next) || isset($previous) ) : ?>
	<div class="products-links">
		<?php
		if ( $next ) {
			echo '<a href="' . esc_url( get_permalink( $next->ID ) ) . '" class="previous-product"><i class="pe-7s-angle-left"></i></a>';
		}

		if ( $previous ) {
			echo '<a href="' . esc_url( get_permalink( $previous->ID ) ) . '" class="next-product"><i class="pe-7s-angle-right"></i></a>';
		}
		?>
	</div>
<?php endif;

// Get page options
$product_style = get_post_meta( get_the_ID(), 'wc-single-style', true );

if ( empty($product_style) ) {
	$product_style = 1;
}

// Get product single style
wc_get_template( 'extras/single/layout-' . esc_attr($product_style) . '.php' );
