<?php
/**
 * Single Product Sale Flash
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/sale-flash.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $product;

// Sale badge type
$badge = erado_get_option( 'wc-badge-type' );

if ( $product->is_on_sale() || ! $product->is_in_stock() ) : ?>
	<span class="badge pa tc dib">
		<?php
		if ( $product->is_on_sale() && $product->is_in_stock() ) {
			if ( $badge == 'text' ) {
				echo apply_filters( 'woocommerce_sale_flash', '<span class="onsale">' . esc_html__( 'Sale', 'erado' ) . '</span>', $post, $product );
			} else {
				$regular_price = $product->get_regular_price();
				$sale_price    = $product->get_sale_price();

				if ( $regular_price != '' ) {
					$sale = '-' . ceil( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 ) . '%';
				} else {
					$sale = esc_html__( 'Sale', 'erado' );
				}
				echo apply_filters( 'woocommerce_sale_flash', '<span class="onsale">' . esc_attr( $sale ) . '</span>', $post, $product );
			}
		}

		if ( ! $product->is_in_stock() ) {
			echo '<span class="sold-out">' . esc_html__( 'Sold Out', 'erado' ) . '</span>';
		}
		?>
	</span>
<?php endif; ?>
