<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$shop_layout = erado_get_option( 'wc-single-product-layout', 'no' );

if ( $upsells ) : ?>
	<div class="upsell-products">
		<div class="addon-title">
			<h3><?php esc_html_e( 'You may also like&hellip;', 'erado' ); ?></h3>
		</div>
		<?php if ( $shop_layout != 'no' ) : ?>
			<div class="related-carousel owl-theme owl-carousel" data-carousel='{"selector":".related-carousel", "itemDesktop": 3, "itemMedium": 3, "itemTablet": 2, "itemMobile": 1, "margin":30 , "nav":true}'>
		<?php elseif ( $shop_fullwidth == 1 ) : ?>
			<div class="related-carousel owl-theme owl-carousel" data-carousel='{"selector":".related-carousel", "itemDesktop": 5, "itemMedium": 3, "itemTablet": 2, "itemMobile": 1, "margin":30 , "nav":true}'>
		<?php else : ?>
			<div class="related-carousel owl-theme owl-carousel" data-carousel='{"selector":".related-carousel", "itemDesktop": 4, "itemMedium": 3, "itemTablet": 2, "itemMobile": 1, "margin":30 , "nav":true}'>
		<?php endif; ?>
			<?php foreach ( $upsells as $upsell ) : ?>
				<?php
				 	$post_object = get_post( $upsell->get_id() );
					setup_postdata( $GLOBALS['post'] =& $post_object );
					wc_get_template_part( 'content', 'product' ); ?>
			<?php endforeach; ?>
		</div>
	</div>
<?php endif;
wp_reset_postdata();
